/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.HrisListEmployeeSkillsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListEmployeeSkillsResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListEmployeeSkillsRequestBuilder {
    private HrisListEmployeeSkillsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallHrisListEmployeeSkills sdk;

    public HrisListEmployeeSkillsRequestBuilder(SDKMethodInterfaces.MethodCallHrisListEmployeeSkills sdk) {
        this.sdk = sdk;
    }

    public HrisListEmployeeSkillsRequestBuilder request(HrisListEmployeeSkillsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListEmployeeSkillsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListEmployeeSkillsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListEmployeeSkillsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listEmployeeSkills(this.request, options);
    }

    public Stream<HrisListEmployeeSkillsResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

