/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.HrisListEmployeeTimeOffRequestsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListEmployeeTimeOffRequestsResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListEmployeeTimeOffRequestsRequestBuilder {
    private HrisListEmployeeTimeOffRequestsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallHrisListEmployeeTimeOffRequests sdk;

    public HrisListEmployeeTimeOffRequestsRequestBuilder(SDKMethodInterfaces.MethodCallHrisListEmployeeTimeOffRequests sdk) {
        this.sdk = sdk;
    }

    public HrisListEmployeeTimeOffRequestsRequestBuilder request(HrisListEmployeeTimeOffRequestsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListEmployeeTimeOffRequestsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListEmployeeTimeOffRequestsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListEmployeeTimeOffRequestsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listEmployeeTimeOffRequests(this.request, options);
    }

    public Stream<HrisListEmployeeTimeOffRequestsResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

