/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsUpsertContentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class LmsUpsertContentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsUpsertContentRequestDto lmsUpsertContentRequestDto;

    @JsonCreator
    public LmsUpsertContentRequest(String xAccountId, LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
        this.xAccountId = xAccountId;
        this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public LmsUpsertContentRequestDto lmsUpsertContentRequestDto() {
        return this.lmsUpsertContentRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LmsUpsertContentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpsertContentRequest withLmsUpsertContentRequestDto(LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
        this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsUpsertContentRequest other = (LmsUpsertContentRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.lmsUpsertContentRequestDto, other.lmsUpsertContentRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.lmsUpsertContentRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsUpsertContentRequest.class, "xAccountId", this.xAccountId, "lmsUpsertContentRequestDto", this.lmsUpsertContentRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private LmsUpsertContentRequestDto lmsUpsertContentRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder lmsUpsertContentRequestDto(LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
            Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
            this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
            return this;
        }

        public LmsUpsertContentRequest build() {
            return new LmsUpsertContentRequest(this.xAccountId, this.lmsUpsertContentRequestDto);
        }
    }
}

