/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateContentBlocksRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class MarketingCreateContentBlockRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

    @JsonCreator
    public MarketingCreateContentBlockRequest(String xAccountId, MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.xAccountId = xAccountId;
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto() {
        return this.marketingCreateContentBlocksRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingCreateContentBlockRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingCreateContentBlockRequest withMarketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingCreateContentBlockRequest other = (MarketingCreateContentBlockRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.marketingCreateContentBlocksRequestDto, other.marketingCreateContentBlocksRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.marketingCreateContentBlocksRequestDto);
    }

    public String toString() {
        return Utils.toString(MarketingCreateContentBlockRequest.class, "xAccountId", this.xAccountId, "marketingCreateContentBlocksRequestDto", this.marketingCreateContentBlocksRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder marketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
            Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
            this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
            return this;
        }

        public MarketingCreateContentBlockRequest build() {
            return new MarketingCreateContentBlockRequest(this.xAccountId, this.marketingCreateContentBlocksRequestDto);
        }
    }
}

