/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.MarketingListOmniChannelTemplatesRequest;
import com.stackone.stackone_client_java.models.operations.MarketingListOmniChannelTemplatesResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class MarketingListOmniChannelTemplatesRequestBuilder {
    private MarketingListOmniChannelTemplatesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallMarketingListOmniChannelTemplates sdk;

    public MarketingListOmniChannelTemplatesRequestBuilder(SDKMethodInterfaces.MethodCallMarketingListOmniChannelTemplates sdk) {
        this.sdk = sdk;
    }

    public MarketingListOmniChannelTemplatesRequestBuilder request(MarketingListOmniChannelTemplatesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MarketingListOmniChannelTemplatesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MarketingListOmniChannelTemplatesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MarketingListOmniChannelTemplatesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listOmniChannelTemplates(this.request, options);
    }

    public Stream<MarketingListOmniChannelTemplatesResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

