/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class MarketingListOmniChannelTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TemplatesPaginated> templatesPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<MarketingListOmniChannelTemplatesResponse>> next = () -> Optional.empty();

    @JsonCreator
    public MarketingListOmniChannelTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TemplatesPaginated> templatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(templatesPaginated, "templatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.templatesPaginated = templatesPaginated;
        this.headers = headers;
    }

    public MarketingListOmniChannelTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TemplatesPaginated> templatesPaginated() {
        return this.templatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<MarketingListOmniChannelTemplatesResponse> next() throws Exception {
        return this.next.call();
    }

    private MarketingListOmniChannelTemplatesResponse withNext(Callable<Optional<MarketingListOmniChannelTemplatesResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingListOmniChannelTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListOmniChannelTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListOmniChannelTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListOmniChannelTemplatesResponse withTemplatesPaginated(TemplatesPaginated templatesPaginated) {
        Utils.checkNotNull(templatesPaginated, "templatesPaginated");
        this.templatesPaginated = Optional.ofNullable(templatesPaginated);
        return this;
    }

    public MarketingListOmniChannelTemplatesResponse withTemplatesPaginated(Optional<? extends TemplatesPaginated> templatesPaginated) {
        Utils.checkNotNull(templatesPaginated, "templatesPaginated");
        this.templatesPaginated = templatesPaginated;
        return this;
    }

    public MarketingListOmniChannelTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListOmniChannelTemplatesResponse other = (MarketingListOmniChannelTemplatesResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.templatesPaginated, other.templatesPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.templatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListOmniChannelTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "templatesPaginated", this.templatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<MarketingListOmniChannelTemplatesResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TemplatesPaginated> templatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder templatesPaginated(TemplatesPaginated templatesPaginated) {
            Utils.checkNotNull(templatesPaginated, "templatesPaginated");
            this.templatesPaginated = Optional.ofNullable(templatesPaginated);
            return this;
        }

        public Builder templatesPaginated(Optional<? extends TemplatesPaginated> templatesPaginated) {
            Utils.checkNotNull(templatesPaginated, "templatesPaginated");
            this.templatesPaginated = templatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<MarketingListOmniChannelTemplatesResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public MarketingListOmniChannelTemplatesResponse build() {
            return new MarketingListOmniChannelTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.templatesPaginated, this.headers).withNext(this.next);
        }
    }
}

