/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LinkedAccountMeta;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StackoneGetAccountMetaInfoResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends LinkedAccountMeta> linkedAccountMeta;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneGetAccountMetaInfoResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends LinkedAccountMeta> linkedAccountMeta, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(linkedAccountMeta, "linkedAccountMeta");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.linkedAccountMeta = linkedAccountMeta;
        this.headers = headers;
    }

    public StackoneGetAccountMetaInfoResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<LinkedAccountMeta> linkedAccountMeta() {
        return this.linkedAccountMeta;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public StackoneGetAccountMetaInfoResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneGetAccountMetaInfoResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneGetAccountMetaInfoResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneGetAccountMetaInfoResponse withLinkedAccountMeta(LinkedAccountMeta linkedAccountMeta) {
        Utils.checkNotNull(linkedAccountMeta, "linkedAccountMeta");
        this.linkedAccountMeta = Optional.ofNullable(linkedAccountMeta);
        return this;
    }

    public StackoneGetAccountMetaInfoResponse withLinkedAccountMeta(Optional<? extends LinkedAccountMeta> linkedAccountMeta) {
        Utils.checkNotNull(linkedAccountMeta, "linkedAccountMeta");
        this.linkedAccountMeta = linkedAccountMeta;
        return this;
    }

    public StackoneGetAccountMetaInfoResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneGetAccountMetaInfoResponse other = (StackoneGetAccountMetaInfoResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.linkedAccountMeta, other.linkedAccountMeta) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.linkedAccountMeta, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneGetAccountMetaInfoResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "linkedAccountMeta", this.linkedAccountMeta, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends LinkedAccountMeta> linkedAccountMeta = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder linkedAccountMeta(LinkedAccountMeta linkedAccountMeta) {
            Utils.checkNotNull(linkedAccountMeta, "linkedAccountMeta");
            this.linkedAccountMeta = Optional.ofNullable(linkedAccountMeta);
            return this;
        }

        public Builder linkedAccountMeta(Optional<? extends LinkedAccountMeta> linkedAccountMeta) {
            Utils.checkNotNull(linkedAccountMeta, "linkedAccountMeta");
            this.linkedAccountMeta = linkedAccountMeta;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneGetAccountMetaInfoResponse build() {
            return new StackoneGetAccountMetaInfoResponse(this.contentType, this.statusCode, this.rawResponse, this.linkedAccountMeta, this.headers);
        }
    }
}

