/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.operations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.WorkEligibilityResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HrisGetEmployeesWorkEligibilityResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The work eligibility of the employee with the given identifiers was retrieved.
     */
    private Optional<? extends WorkEligibilityResult> workEligibilityResult;

    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetEmployeesWorkEligibilityResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends WorkEligibilityResult> workEligibilityResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workEligibilityResult = workEligibilityResult;
        this.headers = headers;
    }
    
    public HrisGetEmployeesWorkEligibilityResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The work eligibility of the employee with the given identifiers was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<WorkEligibilityResult> workEligibilityResult() {
        return (Optional<WorkEligibilityResult>) workEligibilityResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * HTTP response content type for this operation
     */
    public HrisGetEmployeesWorkEligibilityResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public HrisGetEmployeesWorkEligibilityResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public HrisGetEmployeesWorkEligibilityResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The work eligibility of the employee with the given identifiers was retrieved.
     */
    public HrisGetEmployeesWorkEligibilityResponse withWorkEligibilityResult(WorkEligibilityResult workEligibilityResult) {
        Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
        this.workEligibilityResult = Optional.ofNullable(workEligibilityResult);
        return this;
    }

    /**
     * The work eligibility of the employee with the given identifiers was retrieved.
     */
    public HrisGetEmployeesWorkEligibilityResponse withWorkEligibilityResult(Optional<? extends WorkEligibilityResult> workEligibilityResult) {
        Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
        this.workEligibilityResult = workEligibilityResult;
        return this;
    }

    public HrisGetEmployeesWorkEligibilityResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisGetEmployeesWorkEligibilityResponse other = (HrisGetEmployeesWorkEligibilityResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.workEligibilityResult, other.workEligibilityResult) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            workEligibilityResult,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisGetEmployeesWorkEligibilityResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "workEligibilityResult", workEligibilityResult,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends WorkEligibilityResult> workEligibilityResult = Optional.empty();
 
        private Map<String, List<String>> headers;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The work eligibility of the employee with the given identifiers was retrieved.
         */
        public Builder workEligibilityResult(WorkEligibilityResult workEligibilityResult) {
            Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
            this.workEligibilityResult = Optional.ofNullable(workEligibilityResult);
            return this;
        }

        /**
         * The work eligibility of the employee with the given identifiers was retrieved.
         */
        public Builder workEligibilityResult(Optional<? extends WorkEligibilityResult> workEligibilityResult) {
            Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
            this.workEligibilityResult = workEligibilityResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public HrisGetEmployeesWorkEligibilityResponse build() {
            return new HrisGetEmployeesWorkEligibilityResponse(
                contentType,
                statusCode,
                rawResponse,
                workEligibilityResult,
                headers);
        }
    }
}

