/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * ApplicationValue - The status of the application.
 */
@JsonDeserialize(using = ApplicationValue._Deserializer.class)
@JsonSerialize(using = ApplicationValue._Serializer.class)
public class ApplicationValue {

    public static final ApplicationValue ACTIVE = new ApplicationValue("active");
    public static final ApplicationValue ASSESSMENT = new ApplicationValue("assessment");
    public static final ApplicationValue BACKGROUND_CHECK = new ApplicationValue("background_check");
    public static final ApplicationValue CONVERTED = new ApplicationValue("converted");
    public static final ApplicationValue DECLINED_BY_CANDIDATE = new ApplicationValue("declined_by_candidate");
    public static final ApplicationValue HIRED = new ApplicationValue("hired");
    public static final ApplicationValue INTERVIEW = new ApplicationValue("interview");
    public static final ApplicationValue LEAD = new ApplicationValue("lead");
    public static final ApplicationValue OFFER = new ApplicationValue("offer");
    public static final ApplicationValue REFERENCE_CHECK = new ApplicationValue("reference_check");
    public static final ApplicationValue REJECTED = new ApplicationValue("rejected");
    public static final ApplicationValue REVIEW = new ApplicationValue("review");
    public static final ApplicationValue SCREEN = new ApplicationValue("screen");
    public static final ApplicationValue NEW = new ApplicationValue("new");
    public static final ApplicationValue ONBOARDING = new ApplicationValue("onboarding");
    public static final ApplicationValue CREATED = new ApplicationValue("created");
    public static final ApplicationValue ACCEPTED = new ApplicationValue("accepted");
    public static final ApplicationValue SHORT_LIST = new ApplicationValue("short_list");
    public static final ApplicationValue APPROVED = new ApplicationValue("approved");
    public static final ApplicationValue UNMAPPED_VALUE = new ApplicationValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ApplicationValue> values = createValuesMap();
    private static final Map<String, ApplicationValueEnum> enums = createEnumsMap();

    private final String value;

    private ApplicationValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ApplicationValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ApplicationValue
     */ 
    public static ApplicationValue of(String value) {
        synchronized (ApplicationValue.class) {
            return values.computeIfAbsent(value, v -> new ApplicationValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<ApplicationValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ApplicationValue other = (ApplicationValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ApplicationValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ApplicationValue[] values() {
        synchronized (ApplicationValue.class) {
            return values.values().toArray(new ApplicationValue[] {});
        }
    }

    private static final Map<String, ApplicationValue> createValuesMap() {
        Map<String, ApplicationValue> map = new LinkedHashMap<>();
        map.put("active", ACTIVE);
        map.put("assessment", ASSESSMENT);
        map.put("background_check", BACKGROUND_CHECK);
        map.put("converted", CONVERTED);
        map.put("declined_by_candidate", DECLINED_BY_CANDIDATE);
        map.put("hired", HIRED);
        map.put("interview", INTERVIEW);
        map.put("lead", LEAD);
        map.put("offer", OFFER);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("rejected", REJECTED);
        map.put("review", REVIEW);
        map.put("screen", SCREEN);
        map.put("new", NEW);
        map.put("onboarding", ONBOARDING);
        map.put("created", CREATED);
        map.put("accepted", ACCEPTED);
        map.put("short_list", SHORT_LIST);
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationValueEnum> createEnumsMap() {
        Map<String, ApplicationValueEnum> map = new HashMap<>();
        map.put("active", ApplicationValueEnum.ACTIVE);
        map.put("assessment", ApplicationValueEnum.ASSESSMENT);
        map.put("background_check", ApplicationValueEnum.BACKGROUND_CHECK);
        map.put("converted", ApplicationValueEnum.CONVERTED);
        map.put("declined_by_candidate", ApplicationValueEnum.DECLINED_BY_CANDIDATE);
        map.put("hired", ApplicationValueEnum.HIRED);
        map.put("interview", ApplicationValueEnum.INTERVIEW);
        map.put("lead", ApplicationValueEnum.LEAD);
        map.put("offer", ApplicationValueEnum.OFFER);
        map.put("reference_check", ApplicationValueEnum.REFERENCE_CHECK);
        map.put("rejected", ApplicationValueEnum.REJECTED);
        map.put("review", ApplicationValueEnum.REVIEW);
        map.put("screen", ApplicationValueEnum.SCREEN);
        map.put("new", ApplicationValueEnum.NEW);
        map.put("onboarding", ApplicationValueEnum.ONBOARDING);
        map.put("created", ApplicationValueEnum.CREATED);
        map.put("accepted", ApplicationValueEnum.ACCEPTED);
        map.put("short_list", ApplicationValueEnum.SHORT_LIST);
        map.put("approved", ApplicationValueEnum.APPROVED);
        map.put("unmapped_value", ApplicationValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<ApplicationValue> {

        protected _Serializer() {
            super(ApplicationValue.class);
        }

        @Override
        public void serialize(ApplicationValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<ApplicationValue> {

        protected _Deserializer() {
            super(ApplicationValue.class);
        }

        @Override
        public ApplicationValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return ApplicationValue.of(v);
        }
    }
    
    public enum ApplicationValueEnum {

        ACTIVE("active"),
        ASSESSMENT("assessment"),
        BACKGROUND_CHECK("background_check"),
        CONVERTED("converted"),
        DECLINED_BY_CANDIDATE("declined_by_candidate"),
        HIRED("hired"),
        INTERVIEW("interview"),
        LEAD("lead"),
        OFFER("offer"),
        REFERENCE_CHECK("reference_check"),
        REJECTED("rejected"),
        REVIEW("review"),
        SCREEN("screen"),
        NEW("new"),
        ONBOARDING("onboarding"),
        CREATED("created"),
        ACCEPTED("accepted"),
        SHORT_LIST("short_list"),
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ApplicationValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
