/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class CustomFields {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name of the custom field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The value associated with the custom field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends CustomFieldsValue> value;

    /**
     * The unique identifier for the value of the custom field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value_id")
    private JsonNullable<String> valueId;

    /**
     * Provider's unique identifier for the value of the custom field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_value_id")
    private JsonNullable<String> remoteValueId;

    @JsonCreator
    public CustomFields(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("value") JsonNullable<? extends CustomFieldsValue> value,
            @JsonProperty("value_id") JsonNullable<String> valueId,
            @JsonProperty("remote_value_id") JsonNullable<String> remoteValueId) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(valueId, "valueId");
        Utils.checkNotNull(remoteValueId, "remoteValueId");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.value = value;
        this.valueId = valueId;
        this.remoteValueId = remoteValueId;
    }
    
    public CustomFields() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name of the custom field.
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The value associated with the custom field.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CustomFieldsValue> value() {
        return (JsonNullable<CustomFieldsValue>) value;
    }

    /**
     * The unique identifier for the value of the custom field.
     */
    @JsonIgnore
    public JsonNullable<String> valueId() {
        return valueId;
    }

    /**
     * Provider's unique identifier for the value of the custom field.
     */
    @JsonIgnore
    public JsonNullable<String> remoteValueId() {
        return remoteValueId;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public CustomFields withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public CustomFields withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public CustomFields withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public CustomFields withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name of the custom field.
     */
    public CustomFields withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the custom field.
     */
    public CustomFields withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The value associated with the custom field.
     */
    public CustomFields withValue(CustomFieldsValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The value associated with the custom field.
     */
    public CustomFields withValue(JsonNullable<? extends CustomFieldsValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The unique identifier for the value of the custom field.
     */
    public CustomFields withValueId(String valueId) {
        Utils.checkNotNull(valueId, "valueId");
        this.valueId = JsonNullable.of(valueId);
        return this;
    }

    /**
     * The unique identifier for the value of the custom field.
     */
    public CustomFields withValueId(JsonNullable<String> valueId) {
        Utils.checkNotNull(valueId, "valueId");
        this.valueId = valueId;
        return this;
    }

    /**
     * Provider's unique identifier for the value of the custom field.
     */
    public CustomFields withRemoteValueId(String remoteValueId) {
        Utils.checkNotNull(remoteValueId, "remoteValueId");
        this.remoteValueId = JsonNullable.of(remoteValueId);
        return this;
    }

    /**
     * Provider's unique identifier for the value of the custom field.
     */
    public CustomFields withRemoteValueId(JsonNullable<String> remoteValueId) {
        Utils.checkNotNull(remoteValueId, "remoteValueId");
        this.remoteValueId = remoteValueId;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CustomFields other = (CustomFields) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.valueId, other.valueId) &&
            Objects.deepEquals(this.remoteValueId, other.remoteValueId);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            name,
            value,
            valueId,
            remoteValueId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CustomFields.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "value", value,
                "valueId", valueId,
                "remoteValueId", remoteValueId);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends CustomFieldsValue> value = JsonNullable.undefined();
 
        private JsonNullable<String> valueId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteValueId = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * The name of the custom field.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the custom field.
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The value associated with the custom field.
         */
        public Builder value(CustomFieldsValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The value associated with the custom field.
         */
        public Builder value(JsonNullable<? extends CustomFieldsValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The unique identifier for the value of the custom field.
         */
        public Builder valueId(String valueId) {
            Utils.checkNotNull(valueId, "valueId");
            this.valueId = JsonNullable.of(valueId);
            return this;
        }

        /**
         * The unique identifier for the value of the custom field.
         */
        public Builder valueId(JsonNullable<String> valueId) {
            Utils.checkNotNull(valueId, "valueId");
            this.valueId = valueId;
            return this;
        }

        /**
         * Provider's unique identifier for the value of the custom field.
         */
        public Builder remoteValueId(String remoteValueId) {
            Utils.checkNotNull(remoteValueId, "remoteValueId");
            this.remoteValueId = JsonNullable.of(remoteValueId);
            return this;
        }

        /**
         * Provider's unique identifier for the value of the custom field.
         */
        public Builder remoteValueId(JsonNullable<String> remoteValueId) {
            Utils.checkNotNull(remoteValueId, "remoteValueId");
            this.remoteValueId = remoteValueId;
            return this;
        }
        
        public CustomFields build() {
            return new CustomFields(
                id,
                remoteId,
                name,
                value,
                valueId,
                remoteValueId);
        }
    }
}

