/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * EmploymentPayFrequencyValue - The pay frequency of the job postings.
 */
@JsonDeserialize(using = EmploymentPayFrequencyValue._Deserializer.class)
@JsonSerialize(using = EmploymentPayFrequencyValue._Serializer.class)
public class EmploymentPayFrequencyValue {

    public static final EmploymentPayFrequencyValue HOURLY = new EmploymentPayFrequencyValue("hourly");
    public static final EmploymentPayFrequencyValue WEEKLY = new EmploymentPayFrequencyValue("weekly");
    public static final EmploymentPayFrequencyValue BI_WEEKLY = new EmploymentPayFrequencyValue("bi_weekly");
    public static final EmploymentPayFrequencyValue FOUR_WEEKLY = new EmploymentPayFrequencyValue("four_weekly");
    public static final EmploymentPayFrequencyValue SEMI_MONTHLY = new EmploymentPayFrequencyValue("semi_monthly");
    public static final EmploymentPayFrequencyValue MONTHLY = new EmploymentPayFrequencyValue("monthly");
    public static final EmploymentPayFrequencyValue BI_MONTHLY = new EmploymentPayFrequencyValue("bi_monthly");
    public static final EmploymentPayFrequencyValue QUARTERLY = new EmploymentPayFrequencyValue("quarterly");
    public static final EmploymentPayFrequencyValue SEMI_ANNUALLY = new EmploymentPayFrequencyValue("semi_annually");
    public static final EmploymentPayFrequencyValue YEARLY = new EmploymentPayFrequencyValue("yearly");
    public static final EmploymentPayFrequencyValue THIRTEEN_MONTHLY = new EmploymentPayFrequencyValue("thirteen_monthly");
    public static final EmploymentPayFrequencyValue PRO_RATA = new EmploymentPayFrequencyValue("pro_rata");
    public static final EmploymentPayFrequencyValue UNMAPPED_VALUE = new EmploymentPayFrequencyValue("unmapped_value");
    public static final EmploymentPayFrequencyValue HALF_YEARLY = new EmploymentPayFrequencyValue("half_yearly");
    public static final EmploymentPayFrequencyValue DAILY = new EmploymentPayFrequencyValue("daily");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, EmploymentPayFrequencyValue> values = createValuesMap();
    private static final Map<String, EmploymentPayFrequencyValueEnum> enums = createEnumsMap();

    private final String value;

    private EmploymentPayFrequencyValue(String value) {
        this.value = value;
    }

    /**
     * Returns a EmploymentPayFrequencyValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as EmploymentPayFrequencyValue
     */ 
    public static EmploymentPayFrequencyValue of(String value) {
        synchronized (EmploymentPayFrequencyValue.class) {
            return values.computeIfAbsent(value, v -> new EmploymentPayFrequencyValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<EmploymentPayFrequencyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EmploymentPayFrequencyValue other = (EmploymentPayFrequencyValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "EmploymentPayFrequencyValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static EmploymentPayFrequencyValue[] values() {
        synchronized (EmploymentPayFrequencyValue.class) {
            return values.values().toArray(new EmploymentPayFrequencyValue[] {});
        }
    }

    private static final Map<String, EmploymentPayFrequencyValue> createValuesMap() {
        Map<String, EmploymentPayFrequencyValue> map = new LinkedHashMap<>();
        map.put("hourly", HOURLY);
        map.put("weekly", WEEKLY);
        map.put("bi_weekly", BI_WEEKLY);
        map.put("four_weekly", FOUR_WEEKLY);
        map.put("semi_monthly", SEMI_MONTHLY);
        map.put("monthly", MONTHLY);
        map.put("bi_monthly", BI_MONTHLY);
        map.put("quarterly", QUARTERLY);
        map.put("semi_annually", SEMI_ANNUALLY);
        map.put("yearly", YEARLY);
        map.put("thirteen_monthly", THIRTEEN_MONTHLY);
        map.put("pro_rata", PRO_RATA);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("half_yearly", HALF_YEARLY);
        map.put("daily", DAILY);
        return map;
    }

    private static final Map<String, EmploymentPayFrequencyValueEnum> createEnumsMap() {
        Map<String, EmploymentPayFrequencyValueEnum> map = new HashMap<>();
        map.put("hourly", EmploymentPayFrequencyValueEnum.HOURLY);
        map.put("weekly", EmploymentPayFrequencyValueEnum.WEEKLY);
        map.put("bi_weekly", EmploymentPayFrequencyValueEnum.BI_WEEKLY);
        map.put("four_weekly", EmploymentPayFrequencyValueEnum.FOUR_WEEKLY);
        map.put("semi_monthly", EmploymentPayFrequencyValueEnum.SEMI_MONTHLY);
        map.put("monthly", EmploymentPayFrequencyValueEnum.MONTHLY);
        map.put("bi_monthly", EmploymentPayFrequencyValueEnum.BI_MONTHLY);
        map.put("quarterly", EmploymentPayFrequencyValueEnum.QUARTERLY);
        map.put("semi_annually", EmploymentPayFrequencyValueEnum.SEMI_ANNUALLY);
        map.put("yearly", EmploymentPayFrequencyValueEnum.YEARLY);
        map.put("thirteen_monthly", EmploymentPayFrequencyValueEnum.THIRTEEN_MONTHLY);
        map.put("pro_rata", EmploymentPayFrequencyValueEnum.PRO_RATA);
        map.put("unmapped_value", EmploymentPayFrequencyValueEnum.UNMAPPED_VALUE);
        map.put("half_yearly", EmploymentPayFrequencyValueEnum.HALF_YEARLY);
        map.put("daily", EmploymentPayFrequencyValueEnum.DAILY);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<EmploymentPayFrequencyValue> {

        protected _Serializer() {
            super(EmploymentPayFrequencyValue.class);
        }

        @Override
        public void serialize(EmploymentPayFrequencyValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<EmploymentPayFrequencyValue> {

        protected _Deserializer() {
            super(EmploymentPayFrequencyValue.class);
        }

        @Override
        public EmploymentPayFrequencyValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return EmploymentPayFrequencyValue.of(v);
        }
    }
    
    public enum EmploymentPayFrequencyValueEnum {

        HOURLY("hourly"),
        WEEKLY("weekly"),
        BI_WEEKLY("bi_weekly"),
        FOUR_WEEKLY("four_weekly"),
        SEMI_MONTHLY("semi_monthly"),
        MONTHLY("monthly"),
        BI_MONTHLY("bi_monthly"),
        QUARTERLY("quarterly"),
        SEMI_ANNUALLY("semi_annually"),
        YEARLY("yearly"),
        THIRTEEN_MONTHLY("thirteen_monthly"),
        PRO_RATA("pro_rata"),
        UNMAPPED_VALUE("unmapped_value"),
        HALF_YEARLY("half_yearly"),
        DAILY("daily"),;

        private final String value;

        private EmploymentPayFrequencyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
