/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Message {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message_type")
    private JsonNullable<? extends MessageMessageType> messageType;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message_content")
    private JsonNullable<? extends MessageMessageContent> messageContent;

    @JsonCreator
    public Message(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("message_type") JsonNullable<? extends MessageMessageType> messageType,
            @JsonProperty("message_content") JsonNullable<? extends MessageMessageContent> messageContent) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(messageType, "messageType");
        Utils.checkNotNull(messageContent, "messageContent");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.messageType = messageType;
        this.messageContent = messageContent;
    }
    
    public Message() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessageMessageType> messageType() {
        return (JsonNullable<MessageMessageType>) messageType;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessageMessageContent> messageContent() {
        return (JsonNullable<MessageMessageContent>) messageContent;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public Message withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Message withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Message withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Message withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Message withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    public Message withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    public Message withMessageType(MessageMessageType messageType) {
        Utils.checkNotNull(messageType, "messageType");
        this.messageType = JsonNullable.of(messageType);
        return this;
    }

    /**
     * Stackone enum identifying the type of message associated with the content.
     */
    public Message withMessageType(JsonNullable<? extends MessageMessageType> messageType) {
        Utils.checkNotNull(messageType, "messageType");
        this.messageType = messageType;
        return this;
    }

    public Message withMessageContent(MessageMessageContent messageContent) {
        Utils.checkNotNull(messageContent, "messageContent");
        this.messageContent = JsonNullable.of(messageContent);
        return this;
    }

    public Message withMessageContent(JsonNullable<? extends MessageMessageContent> messageContent) {
        Utils.checkNotNull(messageContent, "messageContent");
        this.messageContent = messageContent;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.messageType, other.messageType) &&
            Objects.deepEquals(this.messageContent, other.messageContent);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            name,
            messageType,
            messageContent);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Message.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "messageType", messageType,
                "messageContent", messageContent);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends MessageMessageType> messageType = JsonNullable.undefined();
 
        private JsonNullable<? extends MessageMessageContent> messageContent = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * Stackone enum identifying the type of message associated with the content.
         */
        public Builder messageType(MessageMessageType messageType) {
            Utils.checkNotNull(messageType, "messageType");
            this.messageType = JsonNullable.of(messageType);
            return this;
        }

        /**
         * Stackone enum identifying the type of message associated with the content.
         */
        public Builder messageType(JsonNullable<? extends MessageMessageType> messageType) {
            Utils.checkNotNull(messageType, "messageType");
            this.messageType = messageType;
            return this;
        }

        public Builder messageContent(MessageMessageContent messageContent) {
            Utils.checkNotNull(messageContent, "messageContent");
            this.messageContent = JsonNullable.of(messageContent);
            return this;
        }

        public Builder messageContent(JsonNullable<? extends MessageMessageContent> messageContent) {
            Utils.checkNotNull(messageContent, "messageContent");
            this.messageContent = messageContent;
            return this;
        }
        
        public Message build() {
            return new Message(
                id,
                remoteId,
                name,
                messageType,
                messageContent);
        }
    }
}

