/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class OfferStatus {

    /**
     * The status of the offer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends OfferValue> value;

    /**
     * The source value of the offer status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends OfferSourceValue> sourceValue;

    @JsonCreator
    public OfferStatus(
            @JsonProperty("value") JsonNullable<? extends OfferValue> value,
            @JsonProperty("source_value") JsonNullable<? extends OfferSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public OfferStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the offer.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<OfferValue> value() {
        return (JsonNullable<OfferValue>) value;
    }

    /**
     * The source value of the offer status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<OfferSourceValue> sourceValue() {
        return (JsonNullable<OfferSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The status of the offer.
     */
    public OfferStatus withValue(OfferValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the offer.
     */
    public OfferStatus withValue(JsonNullable<? extends OfferValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the offer status.
     */
    public OfferStatus withSourceValue(OfferSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the offer status.
     */
    public OfferStatus withSourceValue(JsonNullable<? extends OfferSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OfferStatus other = (OfferStatus) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(OfferStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends OfferValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends OfferSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The status of the offer.
         */
        public Builder value(OfferValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the offer.
         */
        public Builder value(JsonNullable<? extends OfferValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the offer status.
         */
        public Builder sourceValue(OfferSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the offer status.
         */
        public Builder sourceValue(JsonNullable<? extends OfferSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public OfferStatus build() {
            return new OfferStatus(
                value,
                sourceValue);
        }
    }
}

