/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * LmsListContentQueryParamFilter
 * 
 * <p>LMS Courses Filter
 */
public class LmsListContentQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Filter to allow filtering of only active content
     */
    @SpeakeasyMetadata("queryParam:name=active")
    private JsonNullable<? extends QueryParamActive> active;

    @JsonCreator
    public LmsListContentQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<? extends QueryParamActive> active) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(active, "active");
        this.updatedAfter = updatedAfter;
        this.active = active;
    }
    
    public LmsListContentQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to allow filtering of only active content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QueryParamActive> active() {
        return (JsonNullable<QueryParamActive>) active;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListContentQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListContentQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to allow filtering of only active content
     */
    public LmsListContentQueryParamFilter withActive(QueryParamActive active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Filter to allow filtering of only active content
     */
    public LmsListContentQueryParamFilter withActive(JsonNullable<? extends QueryParamActive> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsListContentQueryParamFilter other = (LmsListContentQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.active, other.active);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, active);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsListContentQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "active", active);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<? extends QueryParamActive> active = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to allow filtering of only active content
         */
        public Builder active(QueryParamActive active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Filter to allow filtering of only active content
         */
        public Builder active(JsonNullable<? extends QueryParamActive> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public LmsListContentQueryParamFilter build() {

            return new LmsListContentQueryParamFilter(
                updatedAfter, active);
        }

    }
}
