/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.ReadContext;

import static com.stackone.stackone_client_java.utils.Utils.castLong;

// Internal API only

/**
 * Handles pagination using total page count from responses.
 * This tracker is suitable for APIs that return the total number of pages
 * in each response and use that to determine when to stop pagination.
 *
 * @param <ProgressParamT> The numeric type to use for page numbers (e.g., Integer, Long)
 */
public class PageTracker<ProgressParamT extends Number> implements ProgressTrackerStrategy<ProgressParamT> {
    private final String numPagesExpression;
    private final Class<ProgressParamT> pageType;

    private long currentPage;

    /**
     * Creates a new PageTracker with a specified starting page.
     *
     * @param numPagesExpression The JsonPath expression to extract total pages
     * @param pageType           The class of the numeric type to use (e.g., Integer.class, Long.class)
     * @param fromPage           Page number to start pagination from (0-based or 1-based, depending on API)
     */
    public PageTracker(
            String numPagesExpression,
            Class<ProgressParamT> pageType,
            long fromPage) {
        this.numPagesExpression = numPagesExpression;
        this.pageType = pageType;
        this.currentPage = fromPage;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        Long numPages = respJson.read(numPagesExpression, Long.class);
        // If the response does not contain the total number of pages, we assume that the
        // response is paginated and that the total number of pages is unknown.
        if (numPages == null) {
            return false;
        }

        if (currentPage >= numPages) {
            return false;
        }

        currentPage++;
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return castLong(currentPage, pageType);
    }
}