/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.AssignmentSourceValue;
import com.stackone.stackone_client_java.models.components.AssignmentValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class AssignmentStatus {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends AssignmentValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends AssignmentSourceValue> sourceValue;

    @JsonCreator
    public AssignmentStatus(@JsonProperty(value="value") JsonNullable<? extends AssignmentValue> value, @JsonProperty(value="source_value") JsonNullable<? extends AssignmentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public AssignmentStatus() {
        this((JsonNullable<? extends AssignmentValue>)JsonNullable.undefined(), (JsonNullable<? extends AssignmentSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<AssignmentValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<AssignmentSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AssignmentStatus withValue(AssignmentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public AssignmentStatus withValue(JsonNullable<? extends AssignmentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public AssignmentStatus withSourceValue(AssignmentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public AssignmentStatus withSourceValue(JsonNullable<? extends AssignmentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentStatus other = (AssignmentStatus)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(AssignmentStatus.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends AssignmentValue> value = JsonNullable.undefined();
        private JsonNullable<? extends AssignmentSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(AssignmentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends AssignmentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(AssignmentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AssignmentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AssignmentStatus build() {
            return new AssignmentStatus(this.value, this.sourceValue);
        }
    }
}

