/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListCommentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListCommentsResponse;
import com.stackone.stackone_client_java.operations.TicketingListComments;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class TicketingListCommentsRequestBuilder {
    private TicketingListCommentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public TicketingListCommentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListCommentsRequestBuilder request(TicketingListCommentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public TicketingListCommentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListCommentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public TicketingListCommentsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListComments.Sync operation = new TicketingListComments.Sync(this.sdkConfiguration, options);
        return (TicketingListCommentsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<TicketingListCommentsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListComments.Sync operation = new TicketingListComments.Sync(this.sdkConfiguration, options);
        Paginator<TicketingListCommentsRequest, String> iterator = new Paginator<TicketingListCommentsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), TicketingListCommentsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<TicketingListCommentsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

