/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.ProgressTrackerStrategy;

public class PageTracker<ProgressParamT extends Number>
implements ProgressTrackerStrategy<ProgressParamT> {
    private final String numPagesExpression;
    private final Class<ProgressParamT> pageType;
    private long currentPage;

    public PageTracker(String numPagesExpression, Class<ProgressParamT> pageType, long fromPage) {
        this.numPagesExpression = numPagesExpression;
        this.pageType = pageType;
        this.currentPage = fromPage;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        Long numPages = (Long)respJson.read(this.numPagesExpression, Long.class, new Predicate[0]);
        if (numPages == null) {
            return false;
        }
        if (this.currentPage >= numPages) {
            return false;
        }
        ++this.currentPage;
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return (ProgressParamT)((Number)Utils.castLong(this.currentPage, this.pageType));
    }
}

