/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class JsonRpcMessageDto {
    /**
     * JSON-RPC protocol version
     */
    @JsonProperty("jsonrpc")
    private String jsonrpc;

    /**
     * JSON-RPC method name
     */
    @JsonProperty("method")
    private String method;

    /**
     * Method parameters (arbitrary JSON)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("params")
    private Optional<? extends Params> params;

    /**
     * Request id (arbitrary JSON scalar)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private Optional<? extends Id> id;

    @JsonCreator
    public JsonRpcMessageDto(
            @JsonProperty("jsonrpc") String jsonrpc,
            @JsonProperty("method") String method,
            @JsonProperty("params") Optional<? extends Params> params,
            @JsonProperty("id") Optional<? extends Id> id) {
        Utils.checkNotNull(jsonrpc, "jsonrpc");
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(params, "params");
        Utils.checkNotNull(id, "id");
        this.jsonrpc = jsonrpc;
        this.method = method;
        this.params = params;
        this.id = id;
    }
    
    public JsonRpcMessageDto(
            String jsonrpc,
            String method) {
        this(jsonrpc, method, Optional.empty(),
            Optional.empty());
    }

    /**
     * JSON-RPC protocol version
     */
    @JsonIgnore
    public String jsonrpc() {
        return jsonrpc;
    }

    /**
     * JSON-RPC method name
     */
    @JsonIgnore
    public String method() {
        return method;
    }

    /**
     * Method parameters (arbitrary JSON)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Params> params() {
        return (Optional<Params>) params;
    }

    /**
     * Request id (arbitrary JSON scalar)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Id> id() {
        return (Optional<Id>) id;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * JSON-RPC protocol version
     */
    public JsonRpcMessageDto withJsonrpc(String jsonrpc) {
        Utils.checkNotNull(jsonrpc, "jsonrpc");
        this.jsonrpc = jsonrpc;
        return this;
    }

    /**
     * JSON-RPC method name
     */
    public JsonRpcMessageDto withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    /**
     * Method parameters (arbitrary JSON)
     */
    public JsonRpcMessageDto withParams(Params params) {
        Utils.checkNotNull(params, "params");
        this.params = Optional.ofNullable(params);
        return this;
    }


    /**
     * Method parameters (arbitrary JSON)
     */
    public JsonRpcMessageDto withParams(Optional<? extends Params> params) {
        Utils.checkNotNull(params, "params");
        this.params = params;
        return this;
    }

    /**
     * Request id (arbitrary JSON scalar)
     */
    public JsonRpcMessageDto withId(Id id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }


    /**
     * Request id (arbitrary JSON scalar)
     */
    public JsonRpcMessageDto withId(Optional<? extends Id> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JsonRpcMessageDto other = (JsonRpcMessageDto) o;
        return 
            Utils.enhancedDeepEquals(this.jsonrpc, other.jsonrpc) &&
            Utils.enhancedDeepEquals(this.method, other.method) &&
            Utils.enhancedDeepEquals(this.params, other.params) &&
            Utils.enhancedDeepEquals(this.id, other.id);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            jsonrpc, method, params,
            id);
    }
    
    @Override
    public String toString() {
        return Utils.toString(JsonRpcMessageDto.class,
                "jsonrpc", jsonrpc,
                "method", method,
                "params", params,
                "id", id);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String jsonrpc;

        private String method;

        private Optional<? extends Params> params = Optional.empty();

        private Optional<? extends Id> id = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * JSON-RPC protocol version
         */
        public Builder jsonrpc(String jsonrpc) {
            Utils.checkNotNull(jsonrpc, "jsonrpc");
            this.jsonrpc = jsonrpc;
            return this;
        }


        /**
         * JSON-RPC method name
         */
        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }


        /**
         * Method parameters (arbitrary JSON)
         */
        public Builder params(Params params) {
            Utils.checkNotNull(params, "params");
            this.params = Optional.ofNullable(params);
            return this;
        }

        /**
         * Method parameters (arbitrary JSON)
         */
        public Builder params(Optional<? extends Params> params) {
            Utils.checkNotNull(params, "params");
            this.params = params;
            return this;
        }


        /**
         * Request id (arbitrary JSON scalar)
         */
        public Builder id(Id id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * Request id (arbitrary JSON scalar)
         */
        public Builder id(Optional<? extends Id> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public JsonRpcMessageDto build() {

            return new JsonRpcMessageDto(
                jsonrpc, method, params,
                id);
        }

    }
}
