/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteSecurity;
import com.stackone.stackone_client_java.operations.StackoneMcpDelete;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneMcpDeleteRequestBuilder {
    private StackoneMcpDeleteSecurity security;
    private String xAccountId;
    private String mcpSessionId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneMcpDeleteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneMcpDeleteRequestBuilder security(StackoneMcpDeleteSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public StackoneMcpDeleteRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpDeleteRequestBuilder mcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public StackoneMcpDeleteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneMcpDeleteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneMcpDeleteRequest buildRequest() {
        StackoneMcpDeleteRequest request = new StackoneMcpDeleteRequest(this.xAccountId, this.mcpSessionId);
        return request;
    }

    public StackoneMcpDeleteResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneMcpDelete.Sync operation = new StackoneMcpDelete.Sync(this.sdkConfiguration, this.security, options);
        StackoneMcpDeleteRequest request = this.buildRequest();
        return (StackoneMcpDeleteResponse)operation.handleResponse(operation.doRequest(request));
    }
}

