/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.ActionsRpcRequestDto;
import com.stackone.stackone_client_java.models.operations.StackoneRpcActionResponse;
import com.stackone.stackone_client_java.operations.StackoneRpcAction;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneRpcActionRequestBuilder {
    private ActionsRpcRequestDto request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneRpcActionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneRpcActionRequestBuilder request(ActionsRpcRequestDto request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public StackoneRpcActionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneRpcActionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneRpcActionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneRpcAction.Sync operation = new StackoneRpcAction.Sync(this.sdkConfiguration, options);
        return (StackoneRpcActionResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

