/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MessagingGetMessageRequest;
import com.stackone.stackone_client_java.models.operations.async.MessagingGetMessageResponse;
import com.stackone.stackone_client_java.operations.MessagingGetMessage;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MessagingGetMessageRequestBuilder {
    private MessagingGetMessageRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public MessagingGetMessageRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingGetMessageRequestBuilder request(MessagingGetMessageRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MessagingGetMessageRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingGetMessageRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<MessagingGetMessageResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingGetMessage.Async operation = new MessagingGetMessage.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }
}

