/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.AsyncAccounts;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.operations.StackoneDeleteAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccountMetaInfo;
import com.stackone.stackone_client_java.operations.StackoneListLinkedAccounts;
import com.stackone.stackone_client_java.operations.StackoneUpdateAccount;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;

public class Accounts {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncAccounts asyncSDK;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncAccounts(this, sdkConfiguration);
    }

    public AsyncAccounts async() {
        return this.asyncSDK;
    }

    public StackoneListLinkedAccountsRequestBuilder listLinkedAccounts() {
        return new StackoneListLinkedAccountsRequestBuilder(this.sdkConfiguration);
    }

    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request) throws Exception {
        return this.listLinkedAccounts(request, Optional.empty());
    }

    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request, Optional<Options> options) throws Exception {
        StackoneListLinkedAccounts.Sync operation = new StackoneListLinkedAccounts.Sync(this.sdkConfiguration, options, _headers);
        return (StackoneListLinkedAccountsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public StackoneGetAccountRequestBuilder getAccount() {
        return new StackoneGetAccountRequestBuilder(this.sdkConfiguration);
    }

    public StackoneGetAccountResponse getAccount(String id) throws Exception {
        return this.getAccount(id, Optional.empty());
    }

    public StackoneGetAccountResponse getAccount(String id, Optional<Options> options) throws Exception {
        StackoneGetAccountRequest request = StackoneGetAccountRequest.builder().id(id).build();
        StackoneGetAccount.Sync operation = new StackoneGetAccount.Sync(this.sdkConfiguration, options, _headers);
        return (StackoneGetAccountResponse)operation.handleResponse(operation.doRequest(request));
    }

    public StackoneDeleteAccountRequestBuilder deleteAccount() {
        return new StackoneDeleteAccountRequestBuilder(this.sdkConfiguration);
    }

    public StackoneDeleteAccountResponse deleteAccount(String id) throws Exception {
        return this.deleteAccount(id, Optional.empty());
    }

    public StackoneDeleteAccountResponse deleteAccount(String id, Optional<Options> options) throws Exception {
        StackoneDeleteAccountRequest request = StackoneDeleteAccountRequest.builder().id(id).build();
        StackoneDeleteAccount.Sync operation = new StackoneDeleteAccount.Sync(this.sdkConfiguration, options, _headers);
        return (StackoneDeleteAccountResponse)operation.handleResponse(operation.doRequest(request));
    }

    public StackoneUpdateAccountRequestBuilder updateAccount() {
        return new StackoneUpdateAccountRequestBuilder(this.sdkConfiguration);
    }

    public StackoneUpdateAccountResponse updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto) throws Exception {
        return this.updateAccount(id, patchAccountExternalDto, Optional.empty());
    }

    public StackoneUpdateAccountResponse updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto, Optional<Options> options) throws Exception {
        StackoneUpdateAccountRequest request = StackoneUpdateAccountRequest.builder().id(id).patchAccountExternalDto(patchAccountExternalDto).build();
        StackoneUpdateAccount.Sync operation = new StackoneUpdateAccount.Sync(this.sdkConfiguration, options, _headers);
        return (StackoneUpdateAccountResponse)operation.handleResponse(operation.doRequest(request));
    }

    public StackoneGetAccountMetaInfoRequestBuilder getAccountMetaInfo() {
        return new StackoneGetAccountMetaInfoRequestBuilder(this.sdkConfiguration);
    }

    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id) throws Exception {
        return this.getAccountMetaInfo(id, Optional.empty());
    }

    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id, Optional<Options> options) throws Exception {
        StackoneGetAccountMetaInfoRequest request = StackoneGetAccountMetaInfoRequest.builder().id(id).build();
        StackoneGetAccountMetaInfo.Sync operation = new StackoneGetAccountMetaInfo.Sync(this.sdkConfiguration, options, _headers);
        return (StackoneGetAccountMetaInfoResponse)operation.handleResponse(operation.doRequest(request));
    }
}

