/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Actions;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.ActionsRpcRequestDto;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneListActionsMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListActionsMetaResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneRpcActionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneRpcActionResponse;
import com.stackone.stackone_client_java.operations.StackoneListActionsMeta;
import com.stackone.stackone_client_java.operations.StackoneRpcAction;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncActions {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Actions syncSDK;

    AsyncActions(Actions syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Actions sync() {
        return this.syncSDK;
    }

    public StackoneListActionsMetaRequestBuilder listActionsMeta() {
        return new StackoneListActionsMetaRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneListActionsMetaResponse> listActionsMeta(StackoneListActionsMetaRequest request) {
        return this.listActionsMeta(request, Optional.empty());
    }

    public CompletableFuture<StackoneListActionsMetaResponse> listActionsMeta(StackoneListActionsMetaRequest request, Optional<Options> options) {
        StackoneListActionsMeta.Async operation = new StackoneListActionsMeta.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneRpcActionRequestBuilder rpcAction() {
        return new StackoneRpcActionRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneRpcActionResponse> rpcAction(ActionsRpcRequestDto request) {
        return this.rpcAction(request, Optional.empty());
    }

    public CompletableFuture<StackoneRpcActionResponse> rpcAction(ActionsRpcRequestDto request, Optional<Options> options) {
        StackoneRpcAction.Async operation = new StackoneRpcAction.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

