/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Campaign;
import com.stackone.stackone_client_java.models.components.RawResponse;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class CampaignResult {
    @JsonProperty(value="data")
    private Campaign data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw")
    private JsonNullable<? extends List<RawResponse>> raw;

    @JsonCreator
    public CampaignResult(@JsonProperty(value="data") Campaign data, @JsonProperty(value="raw") JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(raw, "raw");
        this.data = data;
        this.raw = raw;
    }

    public CampaignResult(Campaign data) {
        this(data, (JsonNullable<? extends List<RawResponse>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Campaign data() {
        return this.data;
    }

    @JsonIgnore
    public JsonNullable<List<RawResponse>> raw() {
        return this.raw;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CampaignResult withData(Campaign data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public CampaignResult withRaw(List<RawResponse> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    public CampaignResult withRaw(JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignResult other = (CampaignResult)o;
        return Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.raw, other.raw);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.data, this.raw);
    }

    public String toString() {
        return Utils.toString(CampaignResult.class, "data", this.data, "raw", this.raw);
    }

    public static final class Builder {
        private Campaign data;
        private JsonNullable<? extends List<RawResponse>> raw = JsonNullable.undefined();

        private Builder() {
        }

        public Builder data(Campaign data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder raw(List<RawResponse> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends List<RawResponse>> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public CampaignResult build() {
            return new CampaignResult(this.data, this.raw);
        }
    }
}

