/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TimeOffTypeValue {
    public static final TimeOffTypeValue SICK = new TimeOffTypeValue("sick");
    public static final TimeOffTypeValue UNMAPPED_VALUE = new TimeOffTypeValue("unmapped_value");
    public static final TimeOffTypeValue VACATION = new TimeOffTypeValue("vacation");
    public static final TimeOffTypeValue LONG_TERM_DISABILITY = new TimeOffTypeValue("long_term_disability");
    public static final TimeOffTypeValue SHORT_TERM_DISABILITY = new TimeOffTypeValue("short_term_disability");
    public static final TimeOffTypeValue ABSENT = new TimeOffTypeValue("absent");
    public static final TimeOffTypeValue COMP_TIME = new TimeOffTypeValue("comp_time");
    public static final TimeOffTypeValue TRAINING = new TimeOffTypeValue("training");
    public static final TimeOffTypeValue ANNUAL_LEAVE = new TimeOffTypeValue("annual_leave");
    public static final TimeOffTypeValue LEAVE_OF_ABSENCE = new TimeOffTypeValue("leave_of_absence");
    public static final TimeOffTypeValue BREAK = new TimeOffTypeValue("break");
    public static final TimeOffTypeValue CHILD_CARE_LEAVE = new TimeOffTypeValue("child_care_leave");
    public static final TimeOffTypeValue MATERNITY_LEAVE = new TimeOffTypeValue("maternity_leave");
    public static final TimeOffTypeValue JURY_DUTY = new TimeOffTypeValue("jury_duty");
    public static final TimeOffTypeValue SABBATICAL = new TimeOffTypeValue("sabbatical");
    public static final TimeOffTypeValue ACCIDENT = new TimeOffTypeValue("accident");
    public static final TimeOffTypeValue PAID = new TimeOffTypeValue("paid");
    public static final TimeOffTypeValue UNPAID = new TimeOffTypeValue("unpaid");
    public static final TimeOffTypeValue HOLIDAY = new TimeOffTypeValue("holiday");
    public static final TimeOffTypeValue PERSONAL = new TimeOffTypeValue("personal");
    public static final TimeOffTypeValue IN_LIEU = new TimeOffTypeValue("in_lieu");
    public static final TimeOffTypeValue BEREAVEMENT = new TimeOffTypeValue("bereavement");
    public static final TimeOffTypeValue OTHER = new TimeOffTypeValue("other");
    private static final Map<String, TimeOffTypeValue> values = TimeOffTypeValue.createValuesMap();
    private static final Map<String, TimeOffTypeValueEnum> enums = TimeOffTypeValue.createEnumsMap();
    private final String value;

    private TimeOffTypeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffTypeValue of(String value) {
        Class<TimeOffTypeValue> clazz = TimeOffTypeValue.class;
        synchronized (TimeOffTypeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffTypeValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TimeOffTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffTypeValue other = (TimeOffTypeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffTypeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffTypeValue[] values() {
        Class<TimeOffTypeValue> clazz = TimeOffTypeValue.class;
        synchronized (TimeOffTypeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffTypeValue[0]);
        }
    }

    private static final Map<String, TimeOffTypeValue> createValuesMap() {
        LinkedHashMap<String, TimeOffTypeValue> map = new LinkedHashMap<String, TimeOffTypeValue>();
        map.put("sick", SICK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("vacation", VACATION);
        map.put("long_term_disability", LONG_TERM_DISABILITY);
        map.put("short_term_disability", SHORT_TERM_DISABILITY);
        map.put("absent", ABSENT);
        map.put("comp_time", COMP_TIME);
        map.put("training", TRAINING);
        map.put("annual_leave", ANNUAL_LEAVE);
        map.put("leave_of_absence", LEAVE_OF_ABSENCE);
        map.put("break", BREAK);
        map.put("child_care_leave", CHILD_CARE_LEAVE);
        map.put("maternity_leave", MATERNITY_LEAVE);
        map.put("jury_duty", JURY_DUTY);
        map.put("sabbatical", SABBATICAL);
        map.put("accident", ACCIDENT);
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        map.put("other", OTHER);
        return map;
    }

    private static final Map<String, TimeOffTypeValueEnum> createEnumsMap() {
        HashMap<String, TimeOffTypeValueEnum> map = new HashMap<String, TimeOffTypeValueEnum>();
        map.put("sick", TimeOffTypeValueEnum.SICK);
        map.put("unmapped_value", TimeOffTypeValueEnum.UNMAPPED_VALUE);
        map.put("vacation", TimeOffTypeValueEnum.VACATION);
        map.put("long_term_disability", TimeOffTypeValueEnum.LONG_TERM_DISABILITY);
        map.put("short_term_disability", TimeOffTypeValueEnum.SHORT_TERM_DISABILITY);
        map.put("absent", TimeOffTypeValueEnum.ABSENT);
        map.put("comp_time", TimeOffTypeValueEnum.COMP_TIME);
        map.put("training", TimeOffTypeValueEnum.TRAINING);
        map.put("annual_leave", TimeOffTypeValueEnum.ANNUAL_LEAVE);
        map.put("leave_of_absence", TimeOffTypeValueEnum.LEAVE_OF_ABSENCE);
        map.put("break", TimeOffTypeValueEnum.BREAK);
        map.put("child_care_leave", TimeOffTypeValueEnum.CHILD_CARE_LEAVE);
        map.put("maternity_leave", TimeOffTypeValueEnum.MATERNITY_LEAVE);
        map.put("jury_duty", TimeOffTypeValueEnum.JURY_DUTY);
        map.put("sabbatical", TimeOffTypeValueEnum.SABBATICAL);
        map.put("accident", TimeOffTypeValueEnum.ACCIDENT);
        map.put("paid", TimeOffTypeValueEnum.PAID);
        map.put("unpaid", TimeOffTypeValueEnum.UNPAID);
        map.put("holiday", TimeOffTypeValueEnum.HOLIDAY);
        map.put("personal", TimeOffTypeValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffTypeValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffTypeValueEnum.BEREAVEMENT);
        map.put("other", TimeOffTypeValueEnum.OTHER);
        return map;
    }

    public static enum TimeOffTypeValueEnum {
        SICK("sick"),
        UNMAPPED_VALUE("unmapped_value"),
        VACATION("vacation"),
        LONG_TERM_DISABILITY("long_term_disability"),
        SHORT_TERM_DISABILITY("short_term_disability"),
        ABSENT("absent"),
        COMP_TIME("comp_time"),
        TRAINING("training"),
        ANNUAL_LEAVE("annual_leave"),
        LEAVE_OF_ABSENCE("leave_of_absence"),
        BREAK("break"),
        CHILD_CARE_LEAVE("child_care_leave"),
        MATERNITY_LEAVE("maternity_leave"),
        JURY_DUTY("jury_duty"),
        SABBATICAL("sabbatical"),
        ACCIDENT("accident"),
        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),
        OTHER("other");

        private final String value;

        private TimeOffTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TimeOffTypeValue> {
        protected _Deserializer() {
            super(TimeOffTypeValue.class);
        }

        public TimeOffTypeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TimeOffTypeValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TimeOffTypeValue> {
        protected _Serializer() {
            super(TimeOffTypeValue.class);
        }

        public void serialize(TimeOffTypeValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

