/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.errors.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ProviderError;
import com.stackone.stackone_client_java.models.errors.Data;
import com.stackone.stackone_client_java.utils.Utils;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class BadRequestResponse
extends RuntimeException {
    @JsonProperty(value="statusCode")
    private double statusCode;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="timestamp")
    private OffsetDateTime timestamp;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="data")
    private JsonNullable<? extends Data> data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="provider_errors")
    private JsonNullable<? extends List<ProviderError>> providerErrors;

    @JsonCreator
    public BadRequestResponse(@JsonProperty(value="statusCode") double statusCode, @JsonProperty(value="message") String message, @JsonProperty(value="timestamp") OffsetDateTime timestamp, @JsonProperty(value="data") JsonNullable<? extends Data> data, @JsonProperty(value="provider_errors") JsonNullable<? extends List<ProviderError>> providerErrors) {
        super("API error occurred");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(timestamp, "timestamp");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.statusCode = statusCode;
        this.message = message;
        this.timestamp = timestamp;
        this.data = data;
        this.providerErrors = providerErrors;
    }

    public BadRequestResponse(double statusCode, String message, OffsetDateTime timestamp) {
        this(statusCode, message, timestamp, (JsonNullable<? extends Data>)JsonNullable.undefined(), (JsonNullable<? extends List<ProviderError>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public double statusCode() {
        return this.statusCode;
    }

    @JsonIgnore
    public String message() {
        return this.message;
    }

    @Override
    @JsonIgnore
    public String getMessage() {
        return Utils.valueOrNull(this.message);
    }

    @JsonIgnore
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    @JsonIgnore
    public JsonNullable<Data> data() {
        return this.data;
    }

    @JsonIgnore
    public JsonNullable<List<ProviderError>> providerErrors() {
        return this.providerErrors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BadRequestResponse withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public BadRequestResponse withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public BadRequestResponse withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    public BadRequestResponse withData(Data data) {
        Utils.checkNotNull(data, "data");
        this.data = JsonNullable.of((Object)data);
        return this;
    }

    public BadRequestResponse withData(JsonNullable<? extends Data> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public BadRequestResponse withProviderErrors(List<ProviderError> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = JsonNullable.of(providerErrors);
        return this;
    }

    public BadRequestResponse withProviderErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = providerErrors;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BadRequestResponse other = (BadRequestResponse)o;
        return Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.timestamp, other.timestamp) && Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.providerErrors, other.providerErrors);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.statusCode, this.message, this.timestamp, this.data, this.providerErrors);
    }

    @Override
    public String toString() {
        return Utils.toString(BadRequestResponse.class, "statusCode", this.statusCode, "message", this.message, "timestamp", this.timestamp, "data", this.data, "providerErrors", this.providerErrors);
    }

    public static final class Builder {
        private Double statusCode;
        private String message;
        private OffsetDateTime timestamp;
        private JsonNullable<? extends Data> data = JsonNullable.undefined();
        private JsonNullable<? extends List<ProviderError>> providerErrors = JsonNullable.undefined();

        private Builder() {
        }

        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public Builder data(Data data) {
            Utils.checkNotNull(data, "data");
            this.data = JsonNullable.of((Object)data);
            return this;
        }

        public Builder data(JsonNullable<? extends Data> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder providerErrors(List<ProviderError> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = JsonNullable.of(providerErrors);
            return this;
        }

        public Builder providerErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = providerErrors;
            return this;
        }

        public BadRequestResponse build() {
            return new BadRequestResponse(this.statusCode, this.message, this.timestamp, this.data, this.providerErrors);
        }
    }
}

