/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListApplicationsRequest;
import com.stackone.stackone_client_java.models.operations.AtsListApplicationsResponse;
import com.stackone.stackone_client_java.operations.AtsListApplications;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListApplicationsRequestBuilder {
    private AtsListApplicationsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsListApplicationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListApplicationsRequestBuilder request(AtsListApplicationsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListApplicationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListApplicationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListApplicationsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListApplications.Sync operation = new AtsListApplications.Sync(this.sdkConfiguration, options, this._headers);
        return (AtsListApplicationsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AtsListApplicationsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListApplications.Sync operation = new AtsListApplications.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<AtsListApplicationsRequest, String> iterator = new Paginator<AtsListApplicationsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AtsListApplicationsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AtsListApplicationsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

