/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.CrmCreateContactRequestDto;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactResponse;
import com.stackone.stackone_client_java.operations.CrmCreateContact;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class CrmCreateContactRequestBuilder {
    private String xAccountId;
    private CrmCreateContactRequestDto crmCreateContactRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public CrmCreateContactRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CrmCreateContactRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public CrmCreateContactRequestBuilder crmCreateContactRequestDto(CrmCreateContactRequestDto crmCreateContactRequestDto) {
        Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
        this.crmCreateContactRequestDto = crmCreateContactRequestDto;
        return this;
    }

    public CrmCreateContactRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CrmCreateContactRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private CrmCreateContactRequest buildRequest() {
        CrmCreateContactRequest request = new CrmCreateContactRequest(this.xAccountId, this.crmCreateContactRequestDto);
        return request;
    }

    public CrmCreateContactResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmCreateContact.Sync operation = new CrmCreateContact.Sync(this.sdkConfiguration, options, this._headers);
        CrmCreateContactRequest request = this.buildRequest();
        return (CrmCreateContactResponse)operation.handleResponse(operation.doRequest(request));
    }
}

