/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListCompletionsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListCompletionsResponse;
import com.stackone.stackone_client_java.operations.LmsListCompletions;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListCompletionsRequestBuilder {
    private LmsListCompletionsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public LmsListCompletionsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListCompletionsRequestBuilder request(LmsListCompletionsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListCompletionsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListCompletionsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListCompletionsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCompletions.Sync operation = new LmsListCompletions.Sync(this.sdkConfiguration, options, this._headers);
        return (LmsListCompletionsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<LmsListCompletionsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCompletions.Sync operation = new LmsListCompletions.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<LmsListCompletionsRequest, String> iterator = new Paginator<LmsListCompletionsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), LmsListCompletionsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<LmsListCompletionsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

