/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsRejectApplicationRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsRejectApplicationRequest;
import com.stackone.stackone_client_java.models.operations.async.AtsRejectApplicationResponse;
import com.stackone.stackone_client_java.operations.AtsRejectApplication;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsRejectApplicationRequestBuilder {
    private String xAccountId;
    private String id;
    private AtsRejectApplicationRequestDto atsRejectApplicationRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsRejectApplicationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsRejectApplicationRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsRejectApplicationRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsRejectApplicationRequestBuilder atsRejectApplicationRequestDto(AtsRejectApplicationRequestDto atsRejectApplicationRequestDto) {
        Utils.checkNotNull(atsRejectApplicationRequestDto, "atsRejectApplicationRequestDto");
        this.atsRejectApplicationRequestDto = atsRejectApplicationRequestDto;
        return this;
    }

    public AtsRejectApplicationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsRejectApplicationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsRejectApplicationRequest buildRequest() {
        AtsRejectApplicationRequest request = new AtsRejectApplicationRequest(this.xAccountId, this.id, this.atsRejectApplicationRequestDto);
        return request;
    }

    public CompletableFuture<AtsRejectApplicationResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsRejectApplication.Async operation = new AtsRejectApplication.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AtsRejectApplicationRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

