/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequest;
import com.stackone.stackone_client_java.models.operations.async.CrmListAccountsResponse;
import com.stackone.stackone_client_java.operations.CrmListAccounts;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class CrmListAccountsRequestBuilder {
    private CrmListAccountsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public CrmListAccountsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CrmListAccountsRequestBuilder request(CrmListAccountsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CrmListAccountsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CrmListAccountsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<CrmListAccountsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListAccounts.Async operation = new CrmListAccounts.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<CrmListAccountsResponse> callAsPublisher() {
        CrmListAccountsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CrmListAccounts.Async operation = new CrmListAccounts.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AsyncPaginator<CrmListAccountsRequest, String> asyncPaginator = new AsyncPaginator<CrmListAccountsRequest, String>(request, new CursorTracker<String>("$.next", String.class), CrmListAccountsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

