/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListJobsRequest;
import com.stackone.stackone_client_java.models.operations.async.HrisListJobsResponse;
import com.stackone.stackone_client_java.operations.HrisListJobs;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class HrisListJobsRequestBuilder {
    private HrisListJobsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public HrisListJobsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListJobsRequestBuilder request(HrisListJobsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListJobsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListJobsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<HrisListJobsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListJobs.Async operation = new HrisListJobs.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<HrisListJobsResponse> callAsPublisher() {
        HrisListJobsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListJobs.Async operation = new HrisListJobs.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AsyncPaginator<HrisListJobsRequest, String> asyncPaginator = new AsyncPaginator<HrisListJobsRequest, String>(request, new CursorTracker<String>("$.next", String.class), HrisListJobsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

