/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.operations.StackoneGetConnectorMeta;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneGetConnectorMetaRequestBuilder {
    private String provider;
    private JsonNullable<String> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public StackoneGetConnectorMetaRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneGetConnectorMetaRequestBuilder provider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder include(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)include);
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder include(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneGetConnectorMetaRequest buildRequest() {
        StackoneGetConnectorMetaRequest request = new StackoneGetConnectorMetaRequest(this.provider, this.include);
        return request;
    }

    public CompletableFuture<StackoneGetConnectorMetaResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneGetConnectorMeta.Async operation = new StackoneGetConnectorMeta.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        StackoneGetConnectorMetaRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

