/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.TicketingTicketUpdateRequestDto;
import com.stackone.stackone_client_java.models.operations.TicketingUpdateTicketRequest;
import com.stackone.stackone_client_java.models.operations.async.TicketingUpdateTicketResponse;
import com.stackone.stackone_client_java.operations.TicketingUpdateTicket;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class TicketingUpdateTicketRequestBuilder {
    private String xAccountId;
    private String id;
    private TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public TicketingUpdateTicketRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingUpdateTicketRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public TicketingUpdateTicketRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public TicketingUpdateTicketRequestBuilder ticketingTicketUpdateRequestDto(TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
        Utils.checkNotNull(ticketingTicketUpdateRequestDto, "ticketingTicketUpdateRequestDto");
        this.ticketingTicketUpdateRequestDto = ticketingTicketUpdateRequestDto;
        return this;
    }

    public TicketingUpdateTicketRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingUpdateTicketRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private TicketingUpdateTicketRequest buildRequest() {
        TicketingUpdateTicketRequest request = new TicketingUpdateTicketRequest(this.xAccountId, this.id, this.ticketingTicketUpdateRequestDto);
        return request;
    }

    public CompletableFuture<TicketingUpdateTicketResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingUpdateTicket.Async operation = new TicketingUpdateTicket.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        TicketingUpdateTicketRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

