/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AccountingAccountValue {
    public static final AccountingAccountValue ASSET = new AccountingAccountValue("asset");
    public static final AccountingAccountValue LIABILITY = new AccountingAccountValue("liability");
    public static final AccountingAccountValue EQUITY = new AccountingAccountValue("equity");
    public static final AccountingAccountValue REVENUE = new AccountingAccountValue("revenue");
    public static final AccountingAccountValue EXPENSE = new AccountingAccountValue("expense");
    public static final AccountingAccountValue UNMAPPED_VALUE = new AccountingAccountValue("unmapped_value");
    private static final Map<String, AccountingAccountValue> values = AccountingAccountValue.createValuesMap();
    private static final Map<String, AccountingAccountValueEnum> enums = AccountingAccountValue.createEnumsMap();
    private final String value;

    private AccountingAccountValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingAccountValue of(String value) {
        Class<AccountingAccountValue> clazz = AccountingAccountValue.class;
        synchronized (AccountingAccountValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AccountingAccountValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AccountingAccountValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountingAccountValue other = (AccountingAccountValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AccountingAccountValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingAccountValue[] values() {
        Class<AccountingAccountValue> clazz = AccountingAccountValue.class;
        synchronized (AccountingAccountValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AccountingAccountValue[0]);
        }
    }

    private static final Map<String, AccountingAccountValue> createValuesMap() {
        LinkedHashMap<String, AccountingAccountValue> map = new LinkedHashMap<String, AccountingAccountValue>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingAccountValueEnum> createEnumsMap() {
        HashMap<String, AccountingAccountValueEnum> map = new HashMap<String, AccountingAccountValueEnum>();
        map.put("asset", AccountingAccountValueEnum.ASSET);
        map.put("liability", AccountingAccountValueEnum.LIABILITY);
        map.put("equity", AccountingAccountValueEnum.EQUITY);
        map.put("revenue", AccountingAccountValueEnum.REVENUE);
        map.put("expense", AccountingAccountValueEnum.EXPENSE);
        map.put("unmapped_value", AccountingAccountValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AccountingAccountValueEnum {
        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AccountingAccountValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AccountingAccountValue> {
        protected _Deserializer() {
            super(AccountingAccountValue.class);
        }

        public AccountingAccountValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AccountingAccountValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AccountingAccountValue> {
        protected _Serializer() {
            super(AccountingAccountValue.class);
        }

        public void serialize(AccountingAccountValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

