/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScheduledInterviewsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListApplicationsScheduledInterviewsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListApplicationsScheduledInterviewsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.scheduledInterviewsPaginated = scheduledInterviewsPaginated;
        this.headers = headers;
    }

    public AtsListApplicationsScheduledInterviewsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScheduledInterviewsPaginated> scheduledInterviewsPaginated() {
        return this.scheduledInterviewsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListApplicationsScheduledInterviewsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withScheduledInterviewsPaginated(ScheduledInterviewsPaginated scheduledInterviewsPaginated) {
        Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
        this.scheduledInterviewsPaginated = Optional.ofNullable(scheduledInterviewsPaginated);
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withScheduledInterviewsPaginated(Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated) {
        Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
        this.scheduledInterviewsPaginated = scheduledInterviewsPaginated;
        return this;
    }

    public AtsListApplicationsScheduledInterviewsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListApplicationsScheduledInterviewsResponse other = (AtsListApplicationsScheduledInterviewsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.scheduledInterviewsPaginated, other.scheduledInterviewsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.scheduledInterviewsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListApplicationsScheduledInterviewsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "scheduledInterviewsPaginated", this.scheduledInterviewsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder scheduledInterviewsPaginated(ScheduledInterviewsPaginated scheduledInterviewsPaginated) {
            Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
            this.scheduledInterviewsPaginated = Optional.ofNullable(scheduledInterviewsPaginated);
            return this;
        }

        public Builder scheduledInterviewsPaginated(Optional<? extends ScheduledInterviewsPaginated> scheduledInterviewsPaginated) {
            Utils.checkNotNull(scheduledInterviewsPaginated, "scheduledInterviewsPaginated");
            this.scheduledInterviewsPaginated = scheduledInterviewsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListApplicationsScheduledInterviewsResponse build() {
            return new AtsListApplicationsScheduledInterviewsResponse(this.contentType, this.statusCode, this.rawResponse, this.scheduledInterviewsPaginated, this.headers);
        }
    }
}

