/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.errors.AuthException;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.RequestBody;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class SessionManager<T extends HasSessionKey> {
    public static final int REFRESH_BEFORE_EXPIRY_SECONDS = 60;
    private final Map<String, Map<String, Session<T>>> sessions = new HashMap<String, Map<String, Session<T>>>();

    public Session<T> getSession(T credentials, List<String> scopes, Function<List<String>, Session<T>> tokenProvider) {
        Session<T> session;
        String sessionKey = credentials.sessionKey();
        String scopeKey = SessionManager.getScopeKey(scopes);
        Optional<Session<T>> existingSession = this.getExistingSession(sessionKey, scopes);
        if (!existingSession.isPresent()) {
            session = tokenProvider.apply(scopes);
            this.sessions.computeIfAbsent(sessionKey, k -> new HashMap()).put(scopeKey, session);
        } else {
            session = existingSession.get();
        }
        return session;
    }

    private Optional<Session<T>> getExistingSession(String sessionKey, List<String> requiredScopes) {
        Map<String, Session<T>> clientSessions = this.sessions.get(sessionKey);
        if (clientSessions == null) {
            return Optional.empty();
        }
        String scopeKey = SessionManager.getScopeKey(requiredScopes);
        Session<T> exactSession = clientSessions.get(scopeKey);
        if (exactSession != null) {
            if (SessionManager.hasTokenExpired(exactSession.expiresAt, OffsetDateTime.now())) {
                this.removeSession(sessionKey, scopeKey);
            } else {
                return Optional.of(exactSession);
            }
        }
        ArrayList<String> expiredSessionKeys = new ArrayList<String>();
        Session<T> validSession = null;
        for (Map.Entry<String, Session<T>> entry : clientSessions.entrySet()) {
            Session<T> session = entry.getValue();
            if (SessionManager.hasTokenExpired(session.expiresAt, OffsetDateTime.now())) {
                expiredSessionKeys.add(entry.getKey());
                continue;
            }
            if (!SessionManager.hasRequiredScopes(session.scopes, requiredScopes)) continue;
            validSession = session;
        }
        for (String key : expiredSessionKeys) {
            this.removeSession(sessionKey, key);
        }
        return Optional.ofNullable(validSession);
    }

    private static String getScopeKey(List<String> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return "";
        }
        ArrayList<String> sortedScopes = new ArrayList<String>(scopes);
        sortedScopes.sort(String::compareTo);
        return String.join((CharSequence)"&", sortedScopes);
    }

    public static boolean hasTokenExpired(Optional<OffsetDateTime> expiresAt, OffsetDateTime now) {
        return !expiresAt.isEmpty() && now.plusSeconds(60L).isAfter(expiresAt.get());
    }

    public static boolean hasRequiredScopes(List<String> sessionScopes, List<String> requiredScopes) {
        return sessionScopes.containsAll(requiredScopes);
    }

    public void remove(String sessionKey) {
        this.sessions.remove(sessionKey);
    }

    public void removeSession(String sessionKey, String scopeKey) {
        Map<String, Session<T>> clientSessions = this.sessions.get(sessionKey);
        if (clientSessions != null) {
            clientSessions.remove(scopeKey);
            if (clientSessions.isEmpty()) {
                this.sessions.remove(sessionKey);
            }
        }
    }

    public static <T extends HasSessionKey> Session<T> requestOAuth2Token(HTTPClient client, T credentials, List<String> scopes, Map<String, String> body, Map<String, String> headers, URI tokenUri) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(tokenUri).header("Content-Type", "application/x-www-form-urlencoded").POST(RequestBody.serializeFormData(body).body());
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.header(header.getKey(), header.getValue());
            }
            HttpRequest request = requestBuilder.build();
            HttpResponse<InputStream> response = client.send(request);
            if (response.statusCode() != 200) {
                String responseBody = Utils.toUtf8AndClose(response.body());
                throw new AuthException(response.statusCode(), "Unexpected status code " + response.statusCode() + ": " + responseBody);
            }
            TokenResponse t = (TokenResponse)Utils.mapper().readValue(response.body(), TokenResponse.class);
            if (!t.tokenType.orElse("").toLowerCase().equals("bearer")) {
                throw new AuthException("Expected 'Bearer' token type but was '" + t.tokenType.orElse("") + "'");
            }
            Optional<OffsetDateTime> expiresAt = t.expiresInSeconds.map(x -> OffsetDateTime.now().plus((long)x, ChronoUnit.SECONDS));
            return new Session<T>(credentials, t.accessToken, scopes, expiresAt);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static final class TokenResponse {
        @JsonProperty(value="access_token")
        Optional<String> accessToken;
        @JsonProperty(value="token_type")
        Optional<String> tokenType;
        @JsonProperty(value="expires_in")
        Optional<Long> expiresInSeconds;

        TokenResponse() {
        }
    }

    public static final class Session<T> {
        private final T credentials;
        private final Optional<String> token;
        private final List<String> scopes;
        private final Optional<OffsetDateTime> expiresAt;

        public Session(T credentials, Optional<String> token, List<String> scopes, Optional<OffsetDateTime> expiresAt) {
            this.credentials = credentials;
            this.token = token;
            this.scopes = scopes;
            this.expiresAt = expiresAt;
        }

        public T credentials() {
            return this.credentials;
        }

        public Optional<String> token() {
            return this.token;
        }

        public List<String> scopes() {
            return this.scopes;
        }

        public Optional<OffsetDateTime> expiresAt() {
            return this.expiresAt;
        }
    }

    public static interface HasSessionKey {
        public String sessionKey();
    }
}

