/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.ScreeningCreateOrderRequestDto;
import com.stackone.stackone_client_java.models.components.ScreeningResultWebhook;
import com.stackone.stackone_client_java.models.operations.ScreeningCreateScreeningOrderRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningGetScreeningPackageRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningListScreeningPackagesRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningWebhookScreeningResultRequest;
import com.stackone.stackone_client_java.models.operations.async.ScreeningCreateScreeningOrderRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.ScreeningCreateScreeningOrderResponse;
import com.stackone.stackone_client_java.models.operations.async.ScreeningGetScreeningPackageRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.ScreeningGetScreeningPackageResponse;
import com.stackone.stackone_client_java.models.operations.async.ScreeningListScreeningPackagesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.ScreeningListScreeningPackagesResponse;
import com.stackone.stackone_client_java.models.operations.async.ScreeningWebhookScreeningResultRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.ScreeningWebhookScreeningResultResponse;
import com.stackone.stackone_client_java.operations.ScreeningCreateScreeningOrder;
import com.stackone.stackone_client_java.operations.ScreeningGetScreeningPackage;
import com.stackone.stackone_client_java.operations.ScreeningListScreeningPackages;
import com.stackone.stackone_client_java.operations.ScreeningWebhookScreeningResult;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncScreening {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Screening syncSDK;

    AsyncScreening(Screening syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Screening sync() {
        return syncSDK;
    }


    /**
     * List Screening Packages
     * 
     * @return The async call builder
     */
    public ScreeningListScreeningPackagesRequestBuilder listScreeningPackages() {
        return new ScreeningListScreeningPackagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Screening Packages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<ScreeningListScreeningPackagesResponse>} - The async response
     */
    public CompletableFuture<ScreeningListScreeningPackagesResponse> listScreeningPackages(ScreeningListScreeningPackagesRequest request) {
        return listScreeningPackages(request, Optional.empty());
    }

    /**
     * List Screening Packages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<ScreeningListScreeningPackagesResponse>} - The async response
     */
    public CompletableFuture<ScreeningListScreeningPackagesResponse> listScreeningPackages(ScreeningListScreeningPackagesRequest request, Optional<Options> options) {
        AsyncRequestOperation<ScreeningListScreeningPackagesRequest, ScreeningListScreeningPackagesResponse> operation
              = new ScreeningListScreeningPackages.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Screening Package
     * 
     * @return The async call builder
     */
    public ScreeningGetScreeningPackageRequestBuilder getScreeningPackage() {
        return new ScreeningGetScreeningPackageRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Screening Package
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return {@code CompletableFuture<ScreeningGetScreeningPackageResponse>} - The async response
     */
    public CompletableFuture<ScreeningGetScreeningPackageResponse> getScreeningPackage(ScreeningGetScreeningPackageRequest request) {
        return getScreeningPackage(request, Optional.empty());
    }

    /**
     * Get Screening Package
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return {@code CompletableFuture<ScreeningGetScreeningPackageResponse>} - The async response
     */
    public CompletableFuture<ScreeningGetScreeningPackageResponse> getScreeningPackage(ScreeningGetScreeningPackageRequest request, Optional<Options> options) {
        AsyncRequestOperation<ScreeningGetScreeningPackageRequest, ScreeningGetScreeningPackageResponse> operation
              = new ScreeningGetScreeningPackage.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Webhook Screening Result
     * 
     * @return The async call builder
     */
    public ScreeningWebhookScreeningResultRequestBuilder webhookScreeningResult() {
        return new ScreeningWebhookScreeningResultRequestBuilder(sdkConfiguration);
    }

    /**
     * Webhook Screening Result
     * 
     * @param xAccountId The account identifier
     * @param screeningResultWebhook 
     * @return {@code CompletableFuture<ScreeningWebhookScreeningResultResponse>} - The async response
     */
    public CompletableFuture<ScreeningWebhookScreeningResultResponse> webhookScreeningResult(String xAccountId, ScreeningResultWebhook screeningResultWebhook) {
        return webhookScreeningResult(xAccountId, screeningResultWebhook, Optional.empty());
    }

    /**
     * Webhook Screening Result
     * 
     * @param xAccountId The account identifier
     * @param screeningResultWebhook 
     * @param options additional options
     * @return {@code CompletableFuture<ScreeningWebhookScreeningResultResponse>} - The async response
     */
    public CompletableFuture<ScreeningWebhookScreeningResultResponse> webhookScreeningResult(
            String xAccountId, ScreeningResultWebhook screeningResultWebhook,
            Optional<Options> options) {
        ScreeningWebhookScreeningResultRequest request =
            ScreeningWebhookScreeningResultRequest
                .builder()
                .xAccountId(xAccountId)
                .screeningResultWebhook(screeningResultWebhook)
                .build();
        AsyncRequestOperation<ScreeningWebhookScreeningResultRequest, ScreeningWebhookScreeningResultResponse> operation
              = new ScreeningWebhookScreeningResult.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Create Screening Order
     * 
     * @return The async call builder
     */
    public ScreeningCreateScreeningOrderRequestBuilder createScreeningOrder() {
        return new ScreeningCreateScreeningOrderRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Screening Order
     * 
     * @param xAccountId The account identifier
     * @param screeningCreateOrderRequestDto 
     * @return {@code CompletableFuture<ScreeningCreateScreeningOrderResponse>} - The async response
     */
    public CompletableFuture<ScreeningCreateScreeningOrderResponse> createScreeningOrder(String xAccountId, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        return createScreeningOrder(xAccountId, screeningCreateOrderRequestDto, Optional.empty());
    }

    /**
     * Create Screening Order
     * 
     * @param xAccountId The account identifier
     * @param screeningCreateOrderRequestDto 
     * @param options additional options
     * @return {@code CompletableFuture<ScreeningCreateScreeningOrderResponse>} - The async response
     */
    public CompletableFuture<ScreeningCreateScreeningOrderResponse> createScreeningOrder(
            String xAccountId, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto,
            Optional<Options> options) {
        ScreeningCreateScreeningOrderRequest request =
            ScreeningCreateScreeningOrderRequest
                .builder()
                .xAccountId(xAccountId)
                .screeningCreateOrderRequestDto(screeningCreateOrderRequestDto)
                .build();
        AsyncRequestOperation<ScreeningCreateScreeningOrderRequest, ScreeningCreateScreeningOrderResponse> operation
              = new ScreeningCreateScreeningOrder.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
