/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class HrisShiftValue {
    public static final HrisShiftValue DRAFT = new HrisShiftValue("draft");
    public static final HrisShiftValue PUBLISHED = new HrisShiftValue("published");
    public static final HrisShiftValue CONFIRMED = new HrisShiftValue("confirmed");
    public static final HrisShiftValue CANCELLED = new HrisShiftValue("cancelled");
    public static final HrisShiftValue UNMAPPED_VALUE = new HrisShiftValue("unmapped_value");
    private static final Map<String, HrisShiftValue> values = HrisShiftValue.createValuesMap();
    private static final Map<String, HrisShiftValueEnum> enums = HrisShiftValue.createEnumsMap();
    private final String value;

    private HrisShiftValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrisShiftValue of(String value) {
        Class<HrisShiftValue> clazz = HrisShiftValue.class;
        synchronized (HrisShiftValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HrisShiftValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<HrisShiftValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrisShiftValue other = (HrisShiftValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HrisShiftValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrisShiftValue[] values() {
        Class<HrisShiftValue> clazz = HrisShiftValue.class;
        synchronized (HrisShiftValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HrisShiftValue[0]);
        }
    }

    private static final Map<String, HrisShiftValue> createValuesMap() {
        LinkedHashMap<String, HrisShiftValue> map = new LinkedHashMap<String, HrisShiftValue>();
        map.put("draft", DRAFT);
        map.put("published", PUBLISHED);
        map.put("confirmed", CONFIRMED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisShiftValueEnum> createEnumsMap() {
        HashMap<String, HrisShiftValueEnum> map = new HashMap<String, HrisShiftValueEnum>();
        map.put("draft", HrisShiftValueEnum.DRAFT);
        map.put("published", HrisShiftValueEnum.PUBLISHED);
        map.put("confirmed", HrisShiftValueEnum.CONFIRMED);
        map.put("cancelled", HrisShiftValueEnum.CANCELLED);
        map.put("unmapped_value", HrisShiftValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HrisShiftValueEnum {
        DRAFT("draft"),
        PUBLISHED("published"),
        CONFIRMED("confirmed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HrisShiftValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<HrisShiftValue> {
        protected _Deserializer() {
            super(HrisShiftValue.class);
        }

        public HrisShiftValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return HrisShiftValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<HrisShiftValue> {
        protected _Serializer() {
            super(HrisShiftValue.class);
        }

        public void serialize(HrisShiftValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

