/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionResultApiModel;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CrmGetContactCustomFieldDefinitionResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends CustomFieldDefinitionResultApiModel> customFieldDefinitionResultApiModel;
    private Map<String, List<String>> headers;

    @JsonCreator
    public CrmGetContactCustomFieldDefinitionResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends CustomFieldDefinitionResultApiModel> customFieldDefinitionResultApiModel, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(customFieldDefinitionResultApiModel, "customFieldDefinitionResultApiModel");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.customFieldDefinitionResultApiModel = customFieldDefinitionResultApiModel;
        this.headers = headers;
    }

    public CrmGetContactCustomFieldDefinitionResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CustomFieldDefinitionResultApiModel> customFieldDefinitionResultApiModel() {
        return this.customFieldDefinitionResultApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CrmGetContactCustomFieldDefinitionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CrmGetContactCustomFieldDefinitionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CrmGetContactCustomFieldDefinitionResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CrmGetContactCustomFieldDefinitionResponse withCustomFieldDefinitionResultApiModel(CustomFieldDefinitionResultApiModel customFieldDefinitionResultApiModel) {
        Utils.checkNotNull(customFieldDefinitionResultApiModel, "customFieldDefinitionResultApiModel");
        this.customFieldDefinitionResultApiModel = Optional.ofNullable(customFieldDefinitionResultApiModel);
        return this;
    }

    public CrmGetContactCustomFieldDefinitionResponse withCustomFieldDefinitionResultApiModel(Optional<? extends CustomFieldDefinitionResultApiModel> customFieldDefinitionResultApiModel) {
        Utils.checkNotNull(customFieldDefinitionResultApiModel, "customFieldDefinitionResultApiModel");
        this.customFieldDefinitionResultApiModel = customFieldDefinitionResultApiModel;
        return this;
    }

    public CrmGetContactCustomFieldDefinitionResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrmGetContactCustomFieldDefinitionResponse other = (CrmGetContactCustomFieldDefinitionResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.customFieldDefinitionResultApiModel, other.customFieldDefinitionResultApiModel) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.customFieldDefinitionResultApiModel, this.headers);
    }

    public String toString() {
        return Utils.toString(CrmGetContactCustomFieldDefinitionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "customFieldDefinitionResultApiModel", this.customFieldDefinitionResultApiModel, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends CustomFieldDefinitionResultApiModel> customFieldDefinitionResultApiModel = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder customFieldDefinitionResultApiModel(CustomFieldDefinitionResultApiModel customFieldDefinitionResultApiModel) {
            Utils.checkNotNull(customFieldDefinitionResultApiModel, "customFieldDefinitionResultApiModel");
            this.customFieldDefinitionResultApiModel = Optional.ofNullable(customFieldDefinitionResultApiModel);
            return this;
        }

        public Builder customFieldDefinitionResultApiModel(Optional<? extends CustomFieldDefinitionResultApiModel> customFieldDefinitionResultApiModel) {
            Utils.checkNotNull(customFieldDefinitionResultApiModel, "customFieldDefinitionResultApiModel");
            this.customFieldDefinitionResultApiModel = customFieldDefinitionResultApiModel;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public CrmGetContactCustomFieldDefinitionResponse build() {
            return new CrmGetContactCustomFieldDefinitionResponse(this.contentType, this.statusCode, this.rawResponse, this.customFieldDefinitionResultApiModel, this.headers);
        }
    }
}

