/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisShiftsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListShiftsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListShiftsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisShiftsPaginated = hrisShiftsPaginated;
        this.headers = headers;
    }

    public HrisListShiftsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisShiftsPaginated> hrisShiftsPaginated() {
        return this.hrisShiftsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListShiftsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListShiftsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListShiftsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListShiftsResponse withHrisShiftsPaginated(HrisShiftsPaginated hrisShiftsPaginated) {
        Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
        this.hrisShiftsPaginated = Optional.ofNullable(hrisShiftsPaginated);
        return this;
    }

    public HrisListShiftsResponse withHrisShiftsPaginated(Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated) {
        Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
        this.hrisShiftsPaginated = hrisShiftsPaginated;
        return this;
    }

    public HrisListShiftsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListShiftsResponse other = (HrisListShiftsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisShiftsPaginated, other.hrisShiftsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListShiftsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisShiftsPaginated", this.hrisShiftsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisShiftsPaginated(HrisShiftsPaginated hrisShiftsPaginated) {
            Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
            this.hrisShiftsPaginated = Optional.ofNullable(hrisShiftsPaginated);
            return this;
        }

        public Builder hrisShiftsPaginated(Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated) {
            Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
            this.hrisShiftsPaginated = hrisShiftsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListShiftsResponse build() {
            return new HrisListShiftsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftsPaginated, this.headers);
        }
    }
}

