/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Query
 * 
 * <p>Query parameters for the action
 */
public class Query {
    /**
     * Enable debug mode for the action execution
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("debug")
    private JsonNullable<Boolean> debug;


    @JsonIgnore
    private Map<String, Object> additionalProperties;

    @JsonCreator
    public Query(
            @JsonProperty("debug") JsonNullable<Boolean> debug) {
        Utils.checkNotNull(debug, "debug");
        this.debug = debug;
        this.additionalProperties = new HashMap<>();
    }
    
    public Query() {
        this(JsonNullable.undefined());
    }

    /**
     * Enable debug mode for the action execution
     */
    @JsonIgnore
    public JsonNullable<Boolean> debug() {
        return debug;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return additionalProperties;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Enable debug mode for the action execution
     */
    public Query withDebug(boolean debug) {
        Utils.checkNotNull(debug, "debug");
        this.debug = JsonNullable.of(debug);
        return this;
    }

    /**
     * Enable debug mode for the action execution
     */
    public Query withDebug(JsonNullable<Boolean> debug) {
        Utils.checkNotNull(debug, "debug");
        this.debug = debug;
        return this;
    }

    @JsonAnySetter
    public Query withAdditionalProperty(String key, Object value) {
        // note that value can be null because of the way JsonAnySetter works
        Utils.checkNotNull(key, "key");
        additionalProperties.put(key, value); 
        return this;
    }
    public Query withAdditionalProperties(Map<String, Object> additionalProperties) {
        Utils.checkNotNull(additionalProperties, "additionalProperties");
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Query other = (Query) o;
        return 
            Utils.enhancedDeepEquals(this.debug, other.debug) &&
            Utils.enhancedDeepEquals(this.additionalProperties, other.additionalProperties);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            debug, additionalProperties);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Query.class,
                "debug", debug,
                "additionalProperties", additionalProperties);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<Boolean> debug = JsonNullable.undefined();

        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Enable debug mode for the action execution
         */
        public Builder debug(boolean debug) {
            Utils.checkNotNull(debug, "debug");
            this.debug = JsonNullable.of(debug);
            return this;
        }

        /**
         * Enable debug mode for the action execution
         */
        public Builder debug(JsonNullable<Boolean> debug) {
            Utils.checkNotNull(debug, "debug");
            this.debug = debug;
            return this;
        }

        public Builder additionalProperty(String key, Object value) {
            Utils.checkNotNull(key, "key");
            // we could be strict about null values (force the user
            // to pass `JsonNullable.of(null)`) but likely to be a bit 
            // annoying for additional properties building so we'll 
            // relax preconditions.
            this.additionalProperties.put(key, value);
            return this;
        }

        public Builder additionalProperties(Map<String, Object> additionalProperties) {
            Utils.checkNotNull(additionalProperties, "additionalProperties");
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Query build() {

            return new Query(
                debug)
                .withAdditionalProperties(additionalProperties);
        }

    }
}
