/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.operations.StackoneMcpPost;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;

public class StackoneMcpPostRequestBuilder {

    private StackoneMcpPostSecurity security;
    private String xAccountId;
    private Optional<String> mcpSessionId = Optional.empty();
    private JsonRpcMessageDto jsonRpcMessageDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneMcpPostRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneMcpPostRequestBuilder security(StackoneMcpPostSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public StackoneMcpPostRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }
                
    public StackoneMcpPostRequestBuilder mcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = Optional.of(mcpSessionId);
        return this;
    }

    public StackoneMcpPostRequestBuilder mcpSessionId(Optional<String> mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public StackoneMcpPostRequestBuilder jsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.jsonRpcMessageDto = jsonRpcMessageDto;
        return this;
    }
                
    public StackoneMcpPostRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneMcpPostRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private StackoneMcpPostRequest buildRequest() {

        StackoneMcpPostRequest request = new StackoneMcpPostRequest(xAccountId,
            mcpSessionId,
            jsonRpcMessageDto);

        return request;
    }

    public StackoneMcpPostResponse call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<StackoneMcpPostRequest, StackoneMcpPostResponse> operation
              = new StackoneMcpPost.Sync(
                                    sdkConfiguration, security, options,
                                    _headers);
        StackoneMcpPostRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
