/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AccountingJournalValue {
    public static final AccountingJournalValue DRAFT = new AccountingJournalValue("draft");
    public static final AccountingJournalValue POSTED = new AccountingJournalValue("posted");
    public static final AccountingJournalValue VOID = new AccountingJournalValue("void");
    public static final AccountingJournalValue UNMAPPED_VALUE = new AccountingJournalValue("unmapped_value");
    private static final Map<String, AccountingJournalValue> values = AccountingJournalValue.createValuesMap();
    private static final Map<String, AccountingJournalValueEnum> enums = AccountingJournalValue.createEnumsMap();
    private final String value;

    private AccountingJournalValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingJournalValue of(String value) {
        Class<AccountingJournalValue> clazz = AccountingJournalValue.class;
        synchronized (AccountingJournalValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AccountingJournalValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AccountingJournalValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountingJournalValue other = (AccountingJournalValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AccountingJournalValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingJournalValue[] values() {
        Class<AccountingJournalValue> clazz = AccountingJournalValue.class;
        synchronized (AccountingJournalValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AccountingJournalValue[0]);
        }
    }

    private static final Map<String, AccountingJournalValue> createValuesMap() {
        LinkedHashMap<String, AccountingJournalValue> map = new LinkedHashMap<String, AccountingJournalValue>();
        map.put("draft", DRAFT);
        map.put("posted", POSTED);
        map.put("void", VOID);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingJournalValueEnum> createEnumsMap() {
        HashMap<String, AccountingJournalValueEnum> map = new HashMap<String, AccountingJournalValueEnum>();
        map.put("draft", AccountingJournalValueEnum.DRAFT);
        map.put("posted", AccountingJournalValueEnum.POSTED);
        map.put("void", AccountingJournalValueEnum.VOID);
        map.put("unmapped_value", AccountingJournalValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AccountingJournalValueEnum {
        DRAFT("draft"),
        POSTED("posted"),
        VOID("void"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AccountingJournalValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AccountingJournalValue> {
        protected _Deserializer() {
            super(AccountingJournalValue.class);
        }

        public AccountingJournalValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AccountingJournalValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AccountingJournalValue> {
        protected _Serializer() {
            super(AccountingJournalValue.class);
        }

        public void serialize(AccountingJournalValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

