/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AssignmentResultValue {
    public static final AssignmentResultValue PASS = new AssignmentResultValue("Pass");
    public static final AssignmentResultValue FAIL = new AssignmentResultValue("Fail");
    public static final AssignmentResultValue UNMAPPED_VALUE = new AssignmentResultValue("unmapped_value");
    private static final Map<String, AssignmentResultValue> values = AssignmentResultValue.createValuesMap();
    private static final Map<String, AssignmentResultValueEnum> enums = AssignmentResultValue.createEnumsMap();
    private final String value;

    private AssignmentResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssignmentResultValue of(String value) {
        Class<AssignmentResultValue> clazz = AssignmentResultValue.class;
        synchronized (AssignmentResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AssignmentResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AssignmentResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssignmentResultValue other = (AssignmentResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AssignmentResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssignmentResultValue[] values() {
        Class<AssignmentResultValue> clazz = AssignmentResultValue.class;
        synchronized (AssignmentResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AssignmentResultValue[0]);
        }
    }

    private static final Map<String, AssignmentResultValue> createValuesMap() {
        LinkedHashMap<String, AssignmentResultValue> map = new LinkedHashMap<String, AssignmentResultValue>();
        map.put("Pass", PASS);
        map.put("Fail", FAIL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentResultValueEnum> createEnumsMap() {
        HashMap<String, AssignmentResultValueEnum> map = new HashMap<String, AssignmentResultValueEnum>();
        map.put("Pass", AssignmentResultValueEnum.PASS);
        map.put("Fail", AssignmentResultValueEnum.FAIL);
        map.put("unmapped_value", AssignmentResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AssignmentResultValueEnum {
        PASS("Pass"),
        FAIL("Fail"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AssignmentResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AssignmentResultValue> {
        protected _Deserializer() {
            super(AssignmentResultValue.class);
        }

        public AssignmentResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AssignmentResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AssignmentResultValue> {
        protected _Serializer() {
            super(AssignmentResultValue.class);
        }

        public void serialize(AssignmentResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

