/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.AccountingCompanySourceValue;
import com.stackone.stackone_client_java.models.components.AccountingCompanyValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class BaseCurrency {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends AccountingCompanyValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends AccountingCompanySourceValue> sourceValue;

    @JsonCreator
    public BaseCurrency(@JsonProperty(value="value") JsonNullable<? extends AccountingCompanyValue> value, @JsonProperty(value="source_value") JsonNullable<? extends AccountingCompanySourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public BaseCurrency() {
        this((JsonNullable<? extends AccountingCompanyValue>)JsonNullable.undefined(), (JsonNullable<? extends AccountingCompanySourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<AccountingCompanyValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<AccountingCompanySourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BaseCurrency withValue(AccountingCompanyValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public BaseCurrency withValue(JsonNullable<? extends AccountingCompanyValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public BaseCurrency withSourceValue(AccountingCompanySourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public BaseCurrency withSourceValue(JsonNullable<? extends AccountingCompanySourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseCurrency other = (BaseCurrency)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(BaseCurrency.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends AccountingCompanyValue> value = JsonNullable.undefined();
        private JsonNullable<? extends AccountingCompanySourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(AccountingCompanyValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends AccountingCompanyValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(AccountingCompanySourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingCompanySourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public BaseCurrency build() {
            return new BaseCurrency(this.value, this.sourceValue);
        }
    }
}

