/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class EmployeeEmploymentStatusValue {
    public static final EmployeeEmploymentStatusValue ACTIVE = new EmployeeEmploymentStatusValue("active");
    public static final EmployeeEmploymentStatusValue PENDING = new EmployeeEmploymentStatusValue("pending");
    public static final EmployeeEmploymentStatusValue TERMINATED = new EmployeeEmploymentStatusValue("terminated");
    public static final EmployeeEmploymentStatusValue LEAVE = new EmployeeEmploymentStatusValue("leave");
    public static final EmployeeEmploymentStatusValue INACTIVE = new EmployeeEmploymentStatusValue("inactive");
    public static final EmployeeEmploymentStatusValue UNKNOWN = new EmployeeEmploymentStatusValue("unknown");
    public static final EmployeeEmploymentStatusValue UNMAPPED_VALUE = new EmployeeEmploymentStatusValue("unmapped_value");
    private static final Map<String, EmployeeEmploymentStatusValue> values = EmployeeEmploymentStatusValue.createValuesMap();
    private static final Map<String, EmployeeEmploymentStatusValueEnum> enums = EmployeeEmploymentStatusValue.createEnumsMap();
    private final String value;

    private EmployeeEmploymentStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmployeeEmploymentStatusValue of(String value) {
        Class<EmployeeEmploymentStatusValue> clazz = EmployeeEmploymentStatusValue.class;
        synchronized (EmployeeEmploymentStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmployeeEmploymentStatusValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<EmployeeEmploymentStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmployeeEmploymentStatusValue other = (EmployeeEmploymentStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmployeeEmploymentStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmployeeEmploymentStatusValue[] values() {
        Class<EmployeeEmploymentStatusValue> clazz = EmployeeEmploymentStatusValue.class;
        synchronized (EmployeeEmploymentStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmployeeEmploymentStatusValue[0]);
        }
    }

    private static final Map<String, EmployeeEmploymentStatusValue> createValuesMap() {
        LinkedHashMap<String, EmployeeEmploymentStatusValue> map = new LinkedHashMap<String, EmployeeEmploymentStatusValue>();
        map.put("active", ACTIVE);
        map.put("pending", PENDING);
        map.put("terminated", TERMINATED);
        map.put("leave", LEAVE);
        map.put("inactive", INACTIVE);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmployeeEmploymentStatusValueEnum> createEnumsMap() {
        HashMap<String, EmployeeEmploymentStatusValueEnum> map = new HashMap<String, EmployeeEmploymentStatusValueEnum>();
        map.put("active", EmployeeEmploymentStatusValueEnum.ACTIVE);
        map.put("pending", EmployeeEmploymentStatusValueEnum.PENDING);
        map.put("terminated", EmployeeEmploymentStatusValueEnum.TERMINATED);
        map.put("leave", EmployeeEmploymentStatusValueEnum.LEAVE);
        map.put("inactive", EmployeeEmploymentStatusValueEnum.INACTIVE);
        map.put("unknown", EmployeeEmploymentStatusValueEnum.UNKNOWN);
        map.put("unmapped_value", EmployeeEmploymentStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmployeeEmploymentStatusValueEnum {
        ACTIVE("active"),
        PENDING("pending"),
        TERMINATED("terminated"),
        LEAVE("leave"),
        INACTIVE("inactive"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmployeeEmploymentStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<EmployeeEmploymentStatusValue> {
        protected _Deserializer() {
            super(EmployeeEmploymentStatusValue.class);
        }

        public EmployeeEmploymentStatusValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return EmployeeEmploymentStatusValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<EmployeeEmploymentStatusValue> {
        protected _Serializer() {
            super(EmployeeEmploymentStatusValue.class);
        }

        public void serialize(EmployeeEmploymentStatusValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

