/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class FieldType {
    public static final FieldType SHORT_TEXT = new FieldType("short_text");
    public static final FieldType LONG_TEXT = new FieldType("long_text");
    public static final FieldType MULTI_SELECT = new FieldType("multi_select");
    public static final FieldType SINGLE_SELECT = new FieldType("single_select");
    public static final FieldType BOOLEAN = new FieldType("boolean");
    public static final FieldType NUMBER = new FieldType("number");
    public static final FieldType DATE = new FieldType("date");
    public static final FieldType PHONE = new FieldType("phone");
    public static final FieldType EMAIL = new FieldType("email");
    public static final FieldType SCORE = new FieldType("score");
    public static final FieldType LOCATION = new FieldType("location");
    public static final FieldType UNMAPPED_VALUE = new FieldType("unmapped_value");
    private static final Map<String, FieldType> values = FieldType.createValuesMap();
    private static final Map<String, FieldTypeEnum> enums = FieldType.createEnumsMap();
    private final String value;

    private FieldType(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldType of(String value) {
        Class<FieldType> clazz = FieldType.class;
        synchronized (FieldType.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new FieldType((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<FieldTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other = (FieldType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "FieldType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldType[] values() {
        Class<FieldType> clazz = FieldType.class;
        synchronized (FieldType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new FieldType[0]);
        }
    }

    private static final Map<String, FieldType> createValuesMap() {
        LinkedHashMap<String, FieldType> map = new LinkedHashMap<String, FieldType>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("phone", PHONE);
        map.put("email", EMAIL);
        map.put("score", SCORE);
        map.put("location", LOCATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, FieldTypeEnum> createEnumsMap() {
        HashMap<String, FieldTypeEnum> map = new HashMap<String, FieldTypeEnum>();
        map.put("short_text", FieldTypeEnum.SHORT_TEXT);
        map.put("long_text", FieldTypeEnum.LONG_TEXT);
        map.put("multi_select", FieldTypeEnum.MULTI_SELECT);
        map.put("single_select", FieldTypeEnum.SINGLE_SELECT);
        map.put("boolean", FieldTypeEnum.BOOLEAN);
        map.put("number", FieldTypeEnum.NUMBER);
        map.put("date", FieldTypeEnum.DATE);
        map.put("phone", FieldTypeEnum.PHONE);
        map.put("email", FieldTypeEnum.EMAIL);
        map.put("score", FieldTypeEnum.SCORE);
        map.put("location", FieldTypeEnum.LOCATION);
        map.put("unmapped_value", FieldTypeEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum FieldTypeEnum {
        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        PHONE("phone"),
        EMAIL("email"),
        SCORE("score"),
        LOCATION("location"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private FieldTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<FieldType> {
        protected _Deserializer() {
            super(FieldType.class);
        }

        public FieldType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return FieldType.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<FieldType> {
        protected _Serializer() {
            super(FieldType.class);
        }

        public void serialize(FieldType value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

