/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class HRISDivisionValue {
    public static final HRISDivisionValue DEPARTMENT = new HRISDivisionValue("department");
    public static final HRISDivisionValue COMPANY = new HRISDivisionValue("company");
    public static final HRISDivisionValue DIVISION = new HRISDivisionValue("division");
    public static final HRISDivisionValue GROUP = new HRISDivisionValue("group");
    public static final HRISDivisionValue PROJECT = new HRISDivisionValue("project");
    public static final HRISDivisionValue COST_CENTER = new HRISDivisionValue("cost_center");
    public static final HRISDivisionValue TEAM = new HRISDivisionValue("team");
    public static final HRISDivisionValue UNMAPPED_VALUE = new HRISDivisionValue("unmapped_value");
    private static final Map<String, HRISDivisionValue> values = HRISDivisionValue.createValuesMap();
    private static final Map<String, HRISDivisionValueEnum> enums = HRISDivisionValue.createEnumsMap();
    private final String value;

    private HRISDivisionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISDivisionValue of(String value) {
        Class<HRISDivisionValue> clazz = HRISDivisionValue.class;
        synchronized (HRISDivisionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISDivisionValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<HRISDivisionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISDivisionValue other = (HRISDivisionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISDivisionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISDivisionValue[] values() {
        Class<HRISDivisionValue> clazz = HRISDivisionValue.class;
        synchronized (HRISDivisionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISDivisionValue[0]);
        }
    }

    private static final Map<String, HRISDivisionValue> createValuesMap() {
        LinkedHashMap<String, HRISDivisionValue> map = new LinkedHashMap<String, HRISDivisionValue>();
        map.put("department", DEPARTMENT);
        map.put("company", COMPANY);
        map.put("division", DIVISION);
        map.put("group", GROUP);
        map.put("project", PROJECT);
        map.put("cost_center", COST_CENTER);
        map.put("team", TEAM);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISDivisionValueEnum> createEnumsMap() {
        HashMap<String, HRISDivisionValueEnum> map = new HashMap<String, HRISDivisionValueEnum>();
        map.put("department", HRISDivisionValueEnum.DEPARTMENT);
        map.put("company", HRISDivisionValueEnum.COMPANY);
        map.put("division", HRISDivisionValueEnum.DIVISION);
        map.put("group", HRISDivisionValueEnum.GROUP);
        map.put("project", HRISDivisionValueEnum.PROJECT);
        map.put("cost_center", HRISDivisionValueEnum.COST_CENTER);
        map.put("team", HRISDivisionValueEnum.TEAM);
        map.put("unmapped_value", HRISDivisionValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HRISDivisionValueEnum {
        DEPARTMENT("department"),
        COMPANY("company"),
        DIVISION("division"),
        GROUP("group"),
        PROJECT("project"),
        COST_CENTER("cost_center"),
        TEAM("team"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HRISDivisionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<HRISDivisionValue> {
        protected _Deserializer() {
            super(HRISDivisionValue.class);
        }

        public HRISDivisionValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return HRISDivisionValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<HRISDivisionValue> {
        protected _Serializer() {
            super(HRISDivisionValue.class);
        }

        public void serialize(HRISDivisionValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

